/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRelationshipRecordsBackwardsStep
extends ReadRecordsStep<RelationshipRecord> {
    private long id;

    public ReadRelationshipRecordsBackwardsStep(StageControl control, Configuration config, RelationshipStore store) {
        super(control, config, store);
        this.id = this.highId;
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        int size = (int)Math.min((long)batchSize, this.id);
        AbstractBaseRecord[] batch = new RelationshipRecord[size];
        boolean seenReservedId = false;
        for (int i = 0; i < size; ++i) {
            this.cursor.next(--this.id);
            RelationshipRecord newRecord = ((RelationshipRecord)this.record).clone();
            batch[i] = newRecord;
            seenReservedId |= IdValidator.isReservedId(newRecord.getId());
        }
        return (batch = (RelationshipRecord[])this.removeRecordWithReservedId(batch, seenReservedId)).length > 0 ? batch : null;
    }

    @Override
    protected long position() {
        return (this.highId - this.id) * (long)this.store.getRecordSize();
    }
}

