/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class UpdateRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<RECORD[]>
implements StatsProvider {
    protected final RecordStore<RECORD> store;
    private final int recordSize;
    private long recordsUpdated;

    public UpdateRecordsStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, RecordStore<RECORD> store) {
        super(control, "v", (Configuration)config, 1, new StatsProvider[0]);
        this.store = store;
        this.recordSize = store.getRecordSize();
    }

    @Override
    protected void process(RECORD[] batch, BatchSender sender) throws Throwable {
        for (Object record : batch) {
            if (IdValidator.isReservedId(((AbstractBaseRecord)record).getId())) continue;
            if (((AbstractBaseRecord)record).inUse() && !this.accept(record)) {
                record = ((AbstractBaseRecord)record).clone();
                ((AbstractBaseRecord)record).setInUse(false);
            }
            this.update(record);
        }
        this.recordsUpdated += (long)batch.length;
    }

    protected void update(RECORD record) throws Throwable {
        this.store.prepareForCommit(record);
        this.store.updateRecord(record);
    }

    protected boolean accept(RECORD record) {
        return true;
    }

    @Override
    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    @Override
    public Stat stat(Key key) {
        return key == Keys.io_throughput ? new IoThroughputStat(this.startTime, this.endTime, (long)this.recordSize * this.recordsUpdated) : null;
    }

    @Override
    public Key[] keys() {
        return new Keys[]{Keys.io_throughput};
    }
}

