/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.SocketAddressFormat;

public class SocketAddressFormatTest {
    @Test
    public void shouldCreateAdvertisedSocketAddressWithLeadingWhitespace() throws Exception {
        String addressString = this.whitespace(1) + "localhost:9999";
        SocketAddress address = SocketAddressFormat.socketAddress((String)addressString, SocketAddress::new);
        Assert.assertEquals((Object)"localhost", (Object)address.getHostname());
        Assert.assertEquals((long)9999L, (long)address.getPort());
    }

    @Test
    public void shouldCreateAdvertisedSocketAddressWithTrailingWhitespace() throws Exception {
        String addressString = "localhost:9999" + this.whitespace(1);
        SocketAddress address = SocketAddressFormat.socketAddress((String)addressString, SocketAddress::new);
        Assert.assertEquals((Object)"localhost", (Object)address.getHostname());
        Assert.assertEquals((long)9999L, (long)address.getPort());
    }

    @Test
    public void shouldFailToCreateSocketAddressWithMixedInWhitespace() {
        String addressString = "localhost" + this.whitespace(1) + ":9999";
        try {
            SocketAddressFormat.socketAddress((String)addressString, SocketAddress::new);
            TestCase.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToCreateSocketWithTrailingNonNumbers() {
        String addressString = "localhost:9999abc";
        try {
            SocketAddressFormat.socketAddress((String)addressString, SocketAddress::new);
            TestCase.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailOnMissingPort() {
        String addressString = "localhost:";
        try {
            SocketAddressFormat.socketAddress((String)addressString, SocketAddress::new);
            TestCase.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String whitespace(int numberOfWhitespaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfWhitespaces; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

