/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigGroups;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Settings;

public class ConfigTest {
    @Test
    public void shouldApplyDefaults() {
        Config config = new Config(new HashMap(), new Class[]{MySettingsWithDefaults.class});
        Assert.assertThat((Object)config.get(MySettingsWithDefaults.hello), (Matcher)CoreMatchers.is((Object)"Hello, World!"));
    }

    @Test
    public void shouldApplyMigrations() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"old", "hello!"}), new Class[]{MyMigratingSettings.class});
        Assert.assertThat((Object)config.get(MyMigratingSettings.newer), (Matcher)CoreMatchers.is((Object)"hello!"));
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldNotAllowSettingInvalidValues() {
        new Config(MapUtil.stringMap((String[])new String[]{MySettingsWithDefaults.boolSetting.name(), "asd"}), new Class[]{MySettingsWithDefaults.class});
        Assert.fail((String)"Expected validation to fail.");
    }

    @Test
    public void shouldBeAbleToAugmentConfig() throws Exception {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"newer", "old", "non-overlapping", "huzzah"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"newer", "new", "unrelated", "hello"}));
        Assert.assertThat((Object)config.get(Settings.setting((String)"newer", (Function)Settings.STRING, (String)"")), (Matcher)Matchers.equalTo((Object)"new"));
        Assert.assertThat((Object)config.get(Settings.setting((String)"non-overlapping", (Function)Settings.STRING, (String)"")), (Matcher)Matchers.equalTo((Object)"huzzah"));
        Assert.assertThat((Object)config.get(Settings.setting((String)"unrelated", (Function)Settings.STRING, (String)"")), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    public void shouldProvideViewOfGroups() throws Throwable {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"my.users.0.user.name", "Bob", "my.users.0.user.age", "81", "my.users.1.user.name", "Greta", "my.users.1.user.age", "82"}));
        Setting name = Settings.setting((String)"user.name", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
        Setting age = Settings.setting((String)"user.age", (Function)Settings.INTEGER, (String)Settings.NO_DEFAULT);
        List views = (List)config.view(ConfigGroups.groups((String)"my.users"));
        Assert.assertThat((Object)views.size(), (Matcher)Matchers.equalTo((Object)2));
        Configuration bob = (Configuration)views.get(0);
        Assert.assertThat((Object)bob.get(name), (Matcher)Matchers.equalTo((Object)"Bob"));
        Assert.assertThat((Object)bob.get(age), (Matcher)Matchers.equalTo((Object)81));
        Configuration greta = (Configuration)views.get(1);
        Assert.assertThat((Object)greta.get(name), (Matcher)Matchers.equalTo((Object)"Greta"));
        Assert.assertThat((Object)greta.get(age), (Matcher)Matchers.equalTo((Object)82));
        Setting name0 = Settings.setting((String)"my.users.0.user.name", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
        Assert.assertThat((Object)config.get(name0), (Matcher)Matchers.equalTo((Object)"Bob"));
    }

    @Test
    public void shouldFindNoGroupViewWhenGroupNameIsMissing() throws Throwable {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"0.user.name", "Bob", "0.user.age", "81", "1.user.name", "Greta", "1.user.age", "82"}));
        Setting name = Settings.setting((String)"user.name", (Function)Settings.STRING, (String)Settings.NO_DEFAULT);
        Setting age = Settings.setting((String)"user.age", (Function)Settings.INTEGER, (String)Settings.NO_DEFAULT);
        List emptyStrViews = (List)config.view(ConfigGroups.groups((String)""));
        List numViews = (List)config.view(ConfigGroups.groups((String)"0"));
        Assert.assertThat((Object)emptyStrViews.size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)numViews.size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)config.get(Settings.setting((String)"0.user.name", (Function)Settings.STRING, (String)Settings.NO_DEFAULT)), (Matcher)Matchers.equalTo((Object)"Bob"));
    }

    @Test
    public void shouldFindNoGroupViewWhenGroupNameIsWrong() throws Throwable {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"my.users.0.name", "Bob", "my.users.0.age", "81", "my.users.1.name", "Greta", "my.users.1.age", "82"}));
        List views = (List)config.view(ConfigGroups.groups((String)"my"));
        Assert.assertThat((Object)views.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldOnlyReadInsideGroupWhileAccessingSettingsInAGroup() throws Throwable {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{"name", "lemon", "my.users.0.user.name", "Bob", "my.users.0.user.age", "81", "my.users.1.user.name", "Greta", "my.users.1.user.age", "82"}));
        Setting name = Settings.setting((String)"name", (Function)Settings.STRING, (String)"No name given to this poor user");
        Setting age = Settings.setting((String)"age", (Function)Settings.INTEGER, (String)Settings.NO_DEFAULT);
        List views = (List)config.view(ConfigGroups.groups((String)"my.users"));
        Assert.assertThat((Object)views.size(), (Matcher)Matchers.equalTo((Object)2));
        Configuration bob = (Configuration)views.get(0);
        Assert.assertThat((Object)bob.get(name), (Matcher)Matchers.equalTo((Object)"No name given to this poor user"));
        Assert.assertNull((Object)bob.get(age));
        Configuration greta = (Configuration)views.get(1);
        Assert.assertThat((Object)greta.get(name), (Matcher)Matchers.equalTo((Object)"No name given to this poor user"));
        Assert.assertNull((Object)greta.get(age));
        Assert.assertThat((Object)config.get(name), (Matcher)Matchers.equalTo((Object)"lemon"));
        Assert.assertNull((Object)config.get(age));
    }

    public static class MySettingsWithDefaults {
        public static Setting<String> hello = Settings.setting((String)"hello", (Function)Settings.STRING, (String)"Hello, World!");
        public static Setting<Boolean> boolSetting = Settings.setting((String)"bool_setting", (Function)Settings.BOOLEAN, (String)"true");
    }

    public static class MyMigratingSettings {
        @Migrator
        public static ConfigurationMigrator migrator = new BaseConfigurationMigrator(){
            {
                this.add((BaseConfigurationMigrator.Migration)new BaseConfigurationMigrator.SpecificPropertyMigration("old", "Old has been replaced by newer!"){

                    public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                        rawConfiguration.put(newer.name(), value);
                    }
                });
            }
        };
        public static Setting<String> newer = Settings.setting((String)"newer", (Function)Settings.STRING, (String)"");
    }
}

