/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.CollectingIndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IndexCRUDIT {
    private GraphDatabaseAPI db;
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final SchemaIndexProvider mockedIndexProvider = (SchemaIndexProvider)Mockito.mock(SchemaIndexProvider.class);
    private final KernelExtensionFactory<?> mockedIndexProviderFactory = SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("none", this.mockedIndexProvider);
    private ThreadToStatementContextBridge ctxSupplier;
    private final Label myLabel = DynamicLabel.label((String)"MYLABEL");

    @Test
    public void addingANodeWithPropertyShouldGetIndexed() throws Exception {
        String indexProperty = "indexProperty";
        GatheringIndexWriter writer = this.newWriter(indexProperty);
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, this.myLabel, indexProperty);
        int value1 = 12;
        String otherProperty = "otherProperty";
        int otherValue = 17;
        Node node = this.createNode(MapUtil.map((Object[])new Object[]{indexProperty, value1, otherProperty, otherValue}), this.myLabel);
        try (Transaction tx = this.db.beginTx();){
            DataWriteOperations statement = this.ctxSupplier.get().dataWriteOperations();
            int propertyKey1 = statement.propertyKeyGetForName(indexProperty);
            long[] labels = new long[]{statement.labelGetForName(this.myLabel.name())};
            Assert.assertThat((Object)writer.updatesCommitted, (Matcher)CoreMatchers.equalTo((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)node.getId(), (int)propertyKey1, (Object)value1, (long[])labels)})));
            tx.success();
        }
    }

    @Test
    public void addingALabelToPreExistingNodeShouldGetIndexed() throws Exception {
        String indexProperty = "indexProperty";
        GatheringIndexWriter writer = this.newWriter(indexProperty);
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, this.myLabel, indexProperty);
        String otherProperty = "otherProperty";
        int value = 12;
        int otherValue = 17;
        Node node = this.createNode(MapUtil.map((Object[])new Object[]{indexProperty, value, otherProperty, otherValue}), new Label[0]);
        Assert.assertThat((Object)writer.updatesCommitted.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        try (Transaction tx = this.db.beginTx();){
            node.addLabel(this.myLabel);
            tx.success();
        }
        tx = this.db.beginTx();
        var8_8 = null;
        try {
            DataWriteOperations statement = this.ctxSupplier.get().dataWriteOperations();
            int propertyKey1 = statement.propertyKeyGetForName(indexProperty);
            long[] labels = new long[]{statement.labelGetForName(this.myLabel.name())};
            Assert.assertThat((Object)writer.updatesCommitted, (Matcher)CoreMatchers.equalTo((Object)Iterators.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)node.getId(), (int)propertyKey1, (Object)value, (long[])labels)})));
            tx.success();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private Node createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(labels);
            for (Map.Entry<String, Object> prop : properties.entrySet()) {
                node.setProperty(prop.getKey(), prop.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.mockedIndexProvider.storeMigrationParticipant((FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), (PageCache)Matchers.any(PageCache.class), (LabelScanStoreProvider)Matchers.any(LabelScanStoreProvider.class))).thenReturn((Object)StoreMigrationParticipant.NOT_PARTICIPATING);
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem((FileSystemAbstraction)this.fs.get());
        factory.addKernelExtensions(Collections.singletonList(this.mockedIndexProviderFactory));
        this.db = (GraphDatabaseAPI)factory.newImpermanentDatabase();
        this.ctxSupplier = (ThreadToStatementContextBridge)this.db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    private GatheringIndexWriter newWriter(String propertyKey) throws IOException {
        GatheringIndexWriter writer = new GatheringIndexWriter(propertyKey);
        Mockito.when((Object)this.mockedIndexProvider.getPopulator(Matchers.anyLong(), (IndexDescriptor)Matchers.any(IndexDescriptor.class), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)writer);
        Mockito.when((Object)this.mockedIndexProvider.getProviderDescriptor()).thenReturn((Object)TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        Mockito.when((Object)this.mockedIndexProvider.getOnlineAccessor(Matchers.anyLong(), (IndexConfiguration)Matchers.any(IndexConfiguration.class), (IndexSamplingConfig)Matchers.any(IndexSamplingConfig.class))).thenReturn((Object)writer);
        Mockito.when((Object)this.mockedIndexProvider.compareTo((SchemaIndexProvider)Matchers.any(SchemaIndexProvider.class))).thenReturn((Object)1);
        return writer;
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    private class GatheringIndexWriter
    extends IndexAccessor.Adapter
    implements IndexPopulator {
        private final Set<NodePropertyUpdate> updatesCommitted = new HashSet<NodePropertyUpdate>();
        private final String propertyKey;
        private final Map<Object, Set<Long>> indexSamples = new HashMap<Object, Set<Long>>();

        public GatheringIndexWriter(String propertyKey) {
            this.propertyKey = propertyKey;
        }

        public void create() {
        }

        public void add(Collection<NodePropertyUpdate> updates) {
            for (NodePropertyUpdate update : updates) {
                ReadOperations statement = IndexCRUDIT.this.ctxSupplier.get().readOperations();
                this.updatesCommitted.add(update);
            }
        }

        public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
            return this.newUpdater(IndexUpdateMode.ONLINE);
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return new CollectingIndexUpdater(){

                public void close() throws IOException, IndexEntryConflictException {
                    GatheringIndexWriter.this.updatesCommitted.addAll(this.updates);
                }

                public void remove(PrimitiveLongSet nodeIds) throws IOException {
                    throw new UnsupportedOperationException("not expected");
                }
            };
        }

        public void close(boolean populationCompletedSuccessfully) {
        }

        public void markAsFailed(String failure) {
        }

        public void includeSample(NodePropertyUpdate update) {
            this.addValueToSample(update.getNodeId(), update.getValueAfter());
        }

        public void configureSampling(boolean onlineSampling) {
        }

        public IndexSample sampleResult() {
            long indexSize = 0L;
            for (Set<Long> nodeIds : this.indexSamples.values()) {
                indexSize += (long)nodeIds.size();
            }
            return new IndexSample(indexSize, (long)this.indexSamples.size(), indexSize);
        }

        private void addValueToSample(long nodeId, Object propertyValue) {
            Set<Long> nodeIds = this.indexSamples.get(propertyValue);
            if (nodeIds == null) {
                nodeIds = new HashSet<Long>();
                this.indexSamples.put(propertyValue, nodeIds);
            }
            nodeIds.add(nodeId);
        }
    }
}

