/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.IntPredicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PreexistingIndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelSchemaStateStore;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TestSchemaIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.CleanupRule;

public class IndexPopulationJobTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();
    private GraphDatabaseAPI db;
    private final Label FIRST = Label.label((String)"FIRST");
    private final Label SECOND = Label.label((String)"SECOND");
    private final String name = "name";
    private final String age = "age";
    private KernelAPI kernel;
    private IndexStoreView indexStoreView;
    private KernelSchemaStateStore stateHolder;
    private int labelId;

    @Before
    public void before() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.kernel = (KernelAPI)this.db.getDependencyResolver().resolveDependency(KernelAPI.class);
        this.stateHolder = new KernelSchemaStateStore((LogProvider)NullLogProvider.getInstance());
        this.indexStoreView = this.indexStoreView();
        try (KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
             Statement statement = tx.acquireStatement();){
            this.labelId = statement.schemaWriteOperations().labelGetOrCreateForName(this.FIRST.name());
            statement.schemaWriteOperations().labelGetOrCreateForName(this.SECOND.name());
            tx.success();
        }
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void shouldPopulateIndexWithOneNode() throws Exception {
        String value = "Taylor";
        long nodeId = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, new FlippableIndexProxy(), false);
        job.run();
        NodePropertyUpdate update = NodePropertyUpdate.add((long)nodeId, (int)0, (Object)value, (long[])new long[]{0L});
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).configureSampling(true);
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update);
        ((IndexPopulator)Mockito.verify((Object)populator)).add((Collection)Matchers.anyListOf(NodePropertyUpdate.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((PropertyAccessor)this.indexStoreView);
        ((IndexPopulator)Mockito.verify((Object)populator)).sampleResult();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{populator});
    }

    @Test
    public void shouldFlushSchemaStateAfterPopulation() throws Exception {
        String value = "Taylor";
        this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        this.stateHolder.apply(MapUtil.stringMap((String[])new String[]{"key", "original_value"}));
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, new FlippableIndexProxy(), false);
        job.run();
        String result = (String)this.stateHolder.get((Object)"key");
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void shouldPopulateIndexWithASmallDataset() throws Exception {
        String value = "Mattias";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.FIRST);
        this.createNode(MapUtil.map((Object[])new Object[]{"name", value}), this.SECOND);
        this.createNode(MapUtil.map((Object[])new Object[]{"age", 31}), this.FIRST);
        long node4 = this.createNode(MapUtil.map((Object[])new Object[]{"age", 35, "name", value}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, new FlippableIndexProxy(), false);
        job.run();
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)node1, (int)0, (Object)value, (long[])new long[]{0L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)node4, (int)0, (Object)value, (long[])new long[]{0L});
        ((IndexPopulator)Mockito.verify((Object)populator)).create();
        ((IndexPopulator)Mockito.verify((Object)populator)).configureSampling(true);
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update1);
        ((IndexPopulator)Mockito.verify((Object)populator)).includeSample(update2);
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)2))).add((Collection)Matchers.anyListOf(NodePropertyUpdate.class));
        ((IndexPopulator)Mockito.verify((Object)populator)).verifyDeferredConstraints((PropertyAccessor)this.indexStoreView);
        ((IndexPopulator)Mockito.verify((Object)populator)).sampleResult();
        ((IndexPopulator)Mockito.verify((Object)populator)).close(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{populator});
    }

    @Test
    public void shouldIndexConcurrentUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        String changedValue = "changed";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value1}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value2}), this.FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value3}), this.FIRST);
        long changeNode = node1;
        int propertyKeyId = this.getPropertyKeyForName("name");
        NodeChangingWriter populator = new NodeChangingWriter(changeNode, propertyKeyId, value1, changedValue, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", (IndexPopulator)populator, new FlippableIndexProxy(), false);
        populator.setJob(job);
        job.run();
        Set expected = Iterators.asSet((Object[])new Pair[]{Pair.of((Object)node1, (Object)value1), Pair.of((Object)node2, (Object)value2), Pair.of((Object)node3, (Object)value3), Pair.of((Object)node1, (Object)changedValue)});
        Assert.assertEquals((Object)expected, (Object)populator.added);
    }

    @Test
    public void shouldRemoveViaConcurrentIndexUpdatesWhilePopulating() throws Exception {
        String value1 = "Mattias";
        String value2 = "Jacob";
        String value3 = "Stefan";
        long node1 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value1}), this.FIRST);
        long node2 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value2}), this.FIRST);
        long node3 = this.createNode(MapUtil.map((Object[])new Object[]{"name", value3}), this.FIRST);
        int propertyKeyId = this.getPropertyKeyForName("name");
        NodeDeletingWriter populator = new NodeDeletingWriter(node2, propertyKeyId, value2, this.labelId);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", (IndexPopulator)populator, new FlippableIndexProxy(), false);
        populator.setJob(job);
        job.run();
        Map expectedAdded = MapUtil.genericMap((Object[])new Object[]{node1, value1, node2, value2, node3, value3});
        Assert.assertEquals((Object)expectedAdded, (Object)populator.added);
        Map expectedRemoved = MapUtil.genericMap((Object[])new Object[]{node2, value2});
        Assert.assertEquals((Object)expectedRemoved, (Object)populator.removed);
    }

    @Test
    public void shouldTransitionToFailedStateIfPopulationJobCrashes() throws Exception {
        IndexPopulator failingPopulator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        ((IndexPopulator)Mockito.doThrow((Throwable)new RuntimeException("BORK BORK")).when((Object)failingPopulator)).add((Collection)Matchers.any());
        FlippableIndexProxy index = new FlippableIndexProxy();
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.FIRST);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", failingPopulator, index, false);
        job.run();
        MatcherAssert.assertThat((Object)index.getState(), (Matcher)IsEqual.equalTo((Object)InternalIndexState.FAILED));
    }

    @Test
    public void shouldBeAbleToCancelPopulationJob() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.FIRST);
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexStoreView storeView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        ControlledStoreScan storeScan = new ControlledStoreScan();
        Mockito.when((Object)storeView.visitNodes((int[])Matchers.any(int[].class), (IntPredicate)Matchers.any(IntPredicate.class), (Visitor)Matchers.any(), (Visitor)Matchers.any())).thenReturn((Object)storeScan);
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, index, storeView, (LogProvider)NullLogProvider.getInstance(), false);
        OtherThreadExecutor<Object> populationJobRunner = this.cleanup.add(new OtherThreadExecutor<Object>("Population job test runner", null));
        Future<Void> runFuture = populationJobRunner.executeDontWait(state -> {
            job.run();
            return null;
        });
        storeScan.latch.waitForAllToStart();
        job.cancel().get();
        storeScan.latch.waitForAllToFinish();
        runFuture.get();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.times((int)1))).close(false);
        ((FlippableIndexProxy)Mockito.verify((Object)index, (VerificationMode)Mockito.times((int)0))).flip((Callable)Matchers.any(), (FailedIndexProxyFactory)Matchers.any());
        this.assertDoubleLongEquals(0L, 0L, this.indexUpdatesAndSize(this.FIRST, "name"));
        this.assertDoubleLongEquals(0L, 0L, this.indexSample(this.FIRST, "name"));
    }

    @Test
    public void shouldLogJobProgress() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, index, this.indexStoreView, (LogProvider)logProvider, false);
        job.run();
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{match.info("Index population started: [%s]", new Object[]{":FIRST(name)"}), match.info("Index population completed. Index is now online: [%s]", new Object[]{":FIRST(name)"})});
    }

    @Test
    public void shouldLogJobFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, index, this.indexStoreView, (LogProvider)logProvider, false);
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)populator)).create();
        job.run();
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.error(org.hamcrest.Matchers.is((Object)"Failed to populate index: [:FIRST(name)]"), org.hamcrest.Matchers.sameInstance((Object)failure))});
    }

    @Test
    public void shouldFlipToFailedUsingFailedIndexProxyFactory() throws Exception {
        FailedIndexProxyFactory failureDelegateFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", failureDelegateFactory, populator, new FlippableIndexProxy(), this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), false);
        IllegalStateException failure = new IllegalStateException("not successful");
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)populator)).close(true);
        job.run();
        ((FailedIndexProxyFactory)Mockito.verify((Object)failureDelegateFactory)).create((Throwable)Matchers.any(Throwable.class));
        this.assertDoubleLongEquals(0L, 0L, this.indexUpdatesAndSize(this.FIRST, "name"));
        this.assertDoubleLongEquals(0L, 0L, this.indexSample(this.FIRST, "name"));
    }

    @Test
    public void shouldCloseAndFailOnFailure() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        FlippableIndexProxy index = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, index, this.indexStoreView, (LogProvider)logProvider, false);
        String failureMessage = "not successful";
        IllegalStateException failure = new IllegalStateException(failureMessage);
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)populator)).create();
        job.run();
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(Matchers.contains((String)failureMessage));
        this.assertDoubleLongEquals(0L, 0L, this.indexUpdatesAndSize(this.FIRST, "name"));
        this.assertDoubleLongEquals(0L, 0L, this.indexSample(this.FIRST, "name"));
    }

    @Test
    public void shouldFailIfDeferredConstraintViolated() throws Exception {
        this.createNode(MapUtil.map((Object[])new Object[]{"name", "irrelephant"}), this.FIRST);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        FlippableIndexProxy index = new FlippableIndexProxy((IndexProxy)Mockito.mock(IndexProxy.class));
        IndexPopulator populator = (IndexPopulator)Mockito.spy((Object)this.inMemoryPopulator(false));
        IndexPopulationJob job = this.newIndexPopulationJob(this.FIRST, "name", populator, index, this.indexStoreView, (LogProvider)logProvider, true);
        PreexistingIndexEntryConflictException failure = new PreexistingIndexEntryConflictException((Object)"duplicate value", 0L, 1L);
        ((IndexPopulator)Mockito.doThrow((Throwable)failure).when((Object)populator)).verifyDeferredConstraints((PropertyAccessor)this.indexStoreView);
        job.run();
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(Matchers.contains((String)"duplicate value"));
        this.assertDoubleLongEquals(0L, 0L, this.indexUpdatesAndSize(this.FIRST, "name"));
        this.assertDoubleLongEquals(0L, 0L, this.indexSample(this.FIRST, "name"));
    }

    private IndexPopulator inMemoryPopulator(boolean constraint) throws TransactionFailureException {
        IndexConfiguration indexConfig = IndexConfiguration.of((boolean)constraint);
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.empty());
        IndexDescriptor descriptor = this.indexDescriptor(this.FIRST, "name");
        return new InMemoryIndexProvider().getPopulator(21L, descriptor, indexConfig, samplingConfig);
    }

    private IndexPopulationJob newIndexPopulationJob(Label label, String propertyKey, IndexPopulator populator, FlippableIndexProxy flipper, boolean constraint) throws TransactionFailureException {
        return this.newIndexPopulationJob(label, propertyKey, populator, flipper, this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), constraint);
    }

    private IndexPopulationJob newIndexPopulationJob(Label label, String propertyKey, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, boolean constraint) throws TransactionFailureException {
        return this.newIndexPopulationJob(label, propertyKey, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class), populator, flipper, storeView, logProvider, constraint);
    }

    private IndexPopulationJob newIndexPopulationJob(Label label, String propertyKey, FailedIndexProxyFactory failureDelegateFactory, IndexPopulator populator, FlippableIndexProxy flipper, IndexStoreView storeView, LogProvider logProvider, boolean constraint) throws TransactionFailureException {
        IndexDescriptor descriptor = this.indexDescriptor(label, propertyKey);
        flipper.setFlipTarget((IndexProxyFactory)Mockito.mock(IndexProxyFactory.class));
        MultipleIndexPopulator multiPopulator = new MultipleIndexPopulator(storeView, logProvider);
        IndexPopulationJob job = new IndexPopulationJob(storeView, multiPopulator, IndexingService.NO_MONITOR, () -> ((KernelSchemaStateStore)this.stateHolder).clear());
        job.addPopulator(populator, descriptor, IndexConfiguration.of((boolean)constraint), TestSchemaIndexProviderDescriptor.PROVIDER_DESCRIPTOR, String.format(":%s(%s)", label.name(), propertyKey), flipper, failureDelegateFactory);
        return job;
    }

    private IndexDescriptor indexDescriptor(Label label, String propertyKey) throws TransactionFailureException {
        IndexDescriptor descriptor;
        try (KernelTransaction tx = this.kernel.newTransaction(KernelTransaction.Type.implicit, (SecurityContext)AnonymousContext.read());
             Statement statement = tx.acquireStatement();){
            descriptor = new IndexDescriptor(statement.readOperations().labelGetForName(label.name()), statement.readOperations().propertyKeyGetForName(propertyKey));
            tx.success();
        }
        return descriptor;
    }

    /*
     * Exception decompiling
     */
    private Register.DoubleLongRegister indexUpdatesAndSize(Label label, String propertyKey) throws KernelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Register.DoubleLongRegister indexSample(Label label, String propertyKey) throws KernelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void assertDoubleLongEquals(long expectedUniqueValue, long expectedSampledSize, Register.DoubleLongRegister register) {
        Assert.assertEquals((long)expectedUniqueValue, (long)register.readFirst());
        Assert.assertEquals((long)expectedSampledSize, (long)register.readSecond());
    }

    private long createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    private int getPropertyKeyForName(String name) throws TransactionFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IndexStoreView indexStoreView() {
        return (IndexStoreView)this.db.getDependencyResolver().resolveDependency(IndexStoreView.class);
    }

    private class NodeDeletingWriter
    extends IndexPopulator.Adapter {
        private final Map<Long, Object> added = new HashMap<Long, Object>();
        private final Map<Long, Object> removed = new HashMap<Long, Object>();
        private final long nodeToDelete;
        private IndexPopulationJob job;
        private final int propertyKeyId;
        private final Object valueToDelete;
        private final int label;

        NodeDeletingWriter(long nodeToDelete, int propertyKeyId, Object valueToDelete, int label) {
            this.nodeToDelete = nodeToDelete;
            this.propertyKeyId = propertyKeyId;
            this.valueToDelete = valueToDelete;
            this.label = label;
        }

        public void setJob(IndexPopulationJob job) {
            this.job = job;
        }

        public void add(Collection<NodePropertyUpdate> updates) {
            for (NodePropertyUpdate update : updates) {
                if (update.getNodeId() == 2L) {
                    this.job.update(NodePropertyUpdate.remove((long)this.nodeToDelete, (int)this.propertyKeyId, (Object)this.valueToDelete, (long[])new long[]{this.label}));
                }
                this.added.put(update.getNodeId(), update.getValueAfter());
            }
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) {
            return new IndexUpdater(){

                public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                    switch (update.getUpdateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            NodeDeletingWriter.this.added.put(update.getNodeId(), update.getValueAfter());
                            break;
                        }
                        case REMOVED: {
                            NodeDeletingWriter.this.removed.put(update.getNodeId(), update.getValueBefore());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.getUpdateMode().name());
                        }
                    }
                }

                public void close() throws IOException, IndexEntryConflictException {
                }

                public void remove(PrimitiveLongSet nodeIds) {
                    throw new UnsupportedOperationException("not expected");
                }
            };
        }
    }

    private class NodeChangingWriter
    extends IndexPopulator.Adapter {
        private final Set<Pair<Long, Object>> added = new HashSet<Pair<Long, Object>>();
        private IndexPopulationJob job;
        private final long nodeToChange;
        private final Object newValue;
        private final Object previousValue;
        private final int label;
        private final int propertyKeyId;

        NodeChangingWriter(long nodeToChange, int propertyKeyId, Object previousValue, Object newValue, int label) {
            this.nodeToChange = nodeToChange;
            this.propertyKeyId = propertyKeyId;
            this.previousValue = previousValue;
            this.newValue = newValue;
            this.label = label;
        }

        public void add(Collection<NodePropertyUpdate> updates) {
            for (NodePropertyUpdate update : updates) {
                if (update.getNodeId() == 2L) {
                    long[] labels = new long[]{this.label};
                    this.job.update(NodePropertyUpdate.change((long)this.nodeToChange, (int)this.propertyKeyId, (Object)this.previousValue, (long[])labels, (Object)this.newValue, (long[])labels));
                }
                this.added.add((Pair<Long, Object>)Pair.of((Object)update.getNodeId(), (Object)update.getValueAfter()));
            }
        }

        public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) {
            return new IndexUpdater(){

                public void process(NodePropertyUpdate update) throws IOException, IndexEntryConflictException {
                    switch (update.getUpdateMode()) {
                        case ADDED: 
                        case CHANGED: {
                            NodeChangingWriter.this.added.add(Pair.of((Object)update.getNodeId(), (Object)update.getValueAfter()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(update.getUpdateMode().name());
                        }
                    }
                }

                public void close() throws IOException, IndexEntryConflictException {
                }

                public void remove(PrimitiveLongSet nodeIds) {
                    throw new UnsupportedOperationException("not expected");
                }
            };
        }

        public void setJob(IndexPopulationJob job) {
            this.job = job;
        }
    }

    private static class ControlledStoreScan
    implements StoreScan<RuntimeException> {
        private final DoubleLatch latch = new DoubleLatch();

        private ControlledStoreScan() {
        }

        public void run() {
            this.latch.startAndWaitForAllToStartAndFinish();
        }

        public void stop() {
            this.latch.finish();
        }

        public void acceptUpdate(MultipleIndexPopulator.MultipleIndexUpdater updater, NodePropertyUpdate update, long currentlyIndexedNodeId) {
        }

        public PopulationProgress getProgress() {
            return new PopulationProgress(42L, 100L);
        }

        public void configure(List<MultipleIndexPopulator.IndexPopulation> populations) {
        }
    }
}

