/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class InMemoryLabelScanStore
implements LabelScanStore {
    private final Map<Long, Set<Long>> data = new ConcurrentHashMap<Long, Set<Long>>();

    private Set<Long> nodeSetForRemoving(long labelId) {
        return this.data.getOrDefault(labelId, Collections.emptySet());
    }

    private Set<Long> nodeSetForAdding(long labelId) {
        Set<Long> nodes = this.data.get(labelId);
        if (nodes == null) {
            nodes = new ConcurrentSkipListSet<Long>();
            this.data.put(labelId, nodes);
        }
        return nodes;
    }

    public LabelScanReader newReader() {
        return new LabelScanReader(){

            public PrimitiveLongIterator nodesWithLabel(int labelId) {
                Set nodes = (Set)InMemoryLabelScanStore.this.data.get(labelId);
                return nodes != null ? PrimitiveLongCollections.toPrimitiveIterator(nodes.iterator()) : PrimitiveLongCollections.emptyIterator();
            }

            public PrimitiveLongIterator nodesWithAnyOfLabels(int ... labelIds) {
                TreeSet<Long> collectiveNodes = new TreeSet<Long>();
                int[] nArray = labelIds;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    long labelId = nArray[i];
                    Set set = (Set)InMemoryLabelScanStore.this.data.get(labelId);
                    if (set == null) continue;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        collectiveNodes.add(id);
                    }
                }
                return PrimitiveLongCollections.toPrimitiveIterator(collectiveNodes.iterator());
            }

            public PrimitiveLongIterator nodesWithAllLabels(int ... labelIds) {
                Set[] sets = new Set[labelIds.length];
                int cursor = 0;
                int biggestSetIndex = -1;
                int biggestSet = -1;
                int[] nArray = labelIds;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    long labelId = nArray[i];
                    Set set = (Set)InMemoryLabelScanStore.this.data.get(labelId);
                    if (set == null) continue;
                    sets[cursor++] = set;
                    if (set.size() <= biggestSet) continue;
                    biggestSetIndex = cursor - 1;
                    biggestSet = set.size();
                }
                if (cursor == 0) {
                    return PrimitiveLongCollections.emptyIterator();
                }
                HashSet collectiveNodes = new HashSet(sets[biggestSetIndex]);
                for (int i = 0; i < cursor; ++i) {
                    if (i == biggestSetIndex) continue;
                    collectiveNodes.retainAll(sets[i]);
                }
                return PrimitiveLongCollections.toPrimitiveIterator(collectiveNodes.iterator());
            }

            public void close() {
            }

            public PrimitiveLongIterator labelsForNode(long nodeId) {
                PrimitiveLongSet nodes = Primitive.longSet();
                for (Map.Entry entry : InMemoryLabelScanStore.this.data.entrySet()) {
                    if (!((Set)entry.getValue()).contains(nodeId)) continue;
                    nodes.add(((Long)entry.getKey()).longValue());
                }
                return nodes.iterator();
            }
        };
    }

    public ResourceIterator<File> snapshotStoreFiles() {
        return Iterators.emptyIterator();
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
    }

    public LabelScanWriter newWriter() {
        return new InMemoryLabelScanWriter();
    }

    public void force() {
    }

    public AllEntriesLabelScanReader allNodeLabelRanges() {
        final HashMap nodesToLabels = new HashMap();
        for (Map.Entry<Long, Set<Long>> labelToNodes : this.data.entrySet()) {
            for (Long nodeId : labelToNodes.getValue()) {
                if (!nodesToLabels.containsKey(nodeId)) {
                    nodesToLabels.put(nodeId, new HashSet());
                }
                ((Set)nodesToLabels.get(nodeId)).add(labelToNodes.getKey());
            }
        }
        return new AllEntriesLabelScanReader(){

            public long maxCount() {
                return 0L;
            }

            public void close() {
            }

            public Iterator<NodeLabelRange> iterator() {
                NodeLabelRange range = new NodeLabelRange(){

                    public int id() {
                        return 0;
                    }

                    public long[] nodes() {
                        return this.toLongArray(nodesToLabels.keySet());
                    }

                    public long[] labels(long nodeId) {
                        return this.toLongArray((Set)nodesToLabels.get(nodeId));
                    }
                };
                return Collections.singletonList(range).iterator();
            }

            private long[] toLongArray(Set<Long> longs) {
                long[] array = new long[longs.size()];
                int position = 0;
                for (Long entry : longs) {
                    array[position++] = entry;
                }
                return array;
            }
        };
    }

    private class InMemoryLabelScanWriter
    implements LabelScanWriter {
        private InMemoryLabelScanWriter() {
        }

        public void write(NodeLabelUpdate update) throws IOException {
            int i;
            long[] added = new long[update.getLabelsAfter().length];
            long[] removed = new long[update.getLabelsBefore().length];
            int addedIndex = 0;
            int removedIndex = 0;
            for (long labelAfter : update.getLabelsAfter()) {
                if (Arrays.binarySearch(update.getLabelsBefore(), labelAfter) >= 0) continue;
                added[addedIndex++] = labelAfter;
            }
            for (long labelBefore : update.getLabelsBefore()) {
                if (Arrays.binarySearch(update.getLabelsAfter(), labelBefore) >= 0) continue;
                removed[removedIndex++] = labelBefore;
            }
            for (i = 0; i < addedIndex; ++i) {
                InMemoryLabelScanStore.this.nodeSetForAdding(added[i]).add(update.getNodeId());
            }
            for (i = 0; i < removedIndex; ++i) {
                InMemoryLabelScanStore.this.nodeSetForRemoving(removed[i]).remove(update.getNodeId());
            }
        }

        public void close() throws IOException {
        }
    }
}

