/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class RelationshipGroupStoreIT {
    private static final int RELATIONSHIP_COUNT = 20;
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseBuilder builder) {
            builder.setConfig(GraphDatabaseSettings.dense_node_threshold, "1");
        }
    };

    @Test
    public void shouldCreateAllTheseRelationshipTypes() throws Exception {
        int i;
        Node node;
        this.shiftHighId(this.db);
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            for (i = 0; i < 20; ++i) {
                node.createRelationshipTo(this.db.createNode(), this.type(i));
            }
            tx.success();
        }
        var3_2 = null;
        try (Transaction ignored = this.db.beginTx();){
            for (i = 0; i < 20; ++i) {
                Assert.assertEquals((String)"Should be possible to get relationships of type with id in unsigned short range.", (long)1L, (long)Iterables.count((Iterable)node.getRelationships(new RelationshipType[]{this.type(i)})));
            }
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    private void shiftHighId(GraphDatabaseAPI db) {
        RecordStorageEngine storageEngine = (RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        NeoStores neoStores = storageEngine.testAccessNeoStores();
        neoStores.getRelationshipTypeTokenStore().setHighId(32757L);
    }

    private RelationshipType type(int i) {
        return RelationshipType.withName((String)("TYPE_" + i));
    }
}

