/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.FullyCoveringRecordKeys;
import org.neo4j.kernel.impl.store.format.LimitedRecordGenerators;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.RecordGenerators;
import org.neo4j.kernel.impl.store.format.RecordKey;
import org.neo4j.kernel.impl.store.format.RecordKeys;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public abstract class AbstractRecordFormatTest {
    private static final int PAGE_SIZE = (int)ByteUnit.kibiBytes((long)1L);
    private static final long TEST_ITERATIONS = 100000L;
    private static final long TEST_TIME = 1000L;
    private static final int DATA_SIZE = 100;
    protected static final long NULL = Record.NULL_REFERENCE.intValue();
    private static final RandomRule random = new RandomRule();
    private static final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private static final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final TestName name = new TestName();
    @ClassRule
    public static final RuleChain ruleChain = RuleChain.outerRule((TestRule)pageCacheRule).around((TestRule)fsRule).around((TestRule)random);
    private static PageCache pageCache;
    public RecordKeys keys = FullyCoveringRecordKeys.INSTANCE;
    private final RecordFormats formats;
    private final int entityBits;
    private final int propertyBits;
    private RecordGenerators generators;

    protected AbstractRecordFormatTest(RecordFormats formats, int entityBits, int propertyBits) {
        this.formats = formats;
        this.entityBits = entityBits;
        this.propertyBits = propertyBits;
    }

    @BeforeClass
    public static void setupPageCache() {
        pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)fsRule.get());
    }

    @Before
    public void before() {
        this.generators = new LimitedRecordGenerators(random.randoms(), this.entityBits, this.propertyBits, 40, 16, -1L);
    }

    @Test
    public void node() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).node(), this.generators::node, this.keys::node);
    }

    @Test
    public void relationship() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).relationship(), this.generators::relationship, this.keys::relationship);
    }

    @Test
    public void property() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).property(), this.generators::property, this.keys::property);
    }

    @Test
    public void relationshipGroup() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).relationshipGroup(), this.generators::relationshipGroup, this.keys::relationshipGroup);
    }

    @Test
    public void relationshipTypeToken() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).relationshipTypeToken(), this.generators::relationshipTypeToken, this.keys::relationshipTypeToken);
    }

    @Test
    public void propertyKeyToken() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).propertyKeyToken(), this.generators::propertyKeyToken, this.keys::propertyKeyToken);
    }

    @Test
    public void labelToken() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).labelToken(), this.generators::labelToken, this.keys::labelToken);
    }

    @Test
    public void dynamic() throws Exception {
        this.verifyWriteAndRead(() -> ((RecordFormats)this.formats).dynamic(), this.generators::dynamic, this.keys::dynamic);
    }

    private <R extends AbstractBaseRecord> void verifyWriteAndRead(Supplier<RecordFormat<R>> formatSupplier, Supplier<RecordGenerators.Generator<R>> generatorSupplier, Supplier<RecordKey<R>> keySupplier) throws IOException {
        try (PagedFile storeFile = pageCache.map(new File("store-" + this.name.getMethodName()), PAGE_SIZE, new OpenOption[]{StandardOpenOption.CREATE});){
            RecordFormat<R> format = formatSupplier.get();
            RecordKey<R> key = keySupplier.get();
            RecordGenerators.Generator<R> generator = generatorSupplier.get();
            int recordSize = format.getRecordSize((StoreHeader)new IntStoreHeader(100));
            BatchingIdSequence idSequence = new BatchingIdSequence(random.nextBoolean() ? this.idSureToBeOnTheNextPage(PAGE_SIZE, recordSize) : 10L);
            long time = System.currentTimeMillis();
            long endTime = time + 1000L;
            for (long i = 0L; i < 100000L && System.currentTimeMillis() < endTime; ++i) {
                R written = generator.get(recordSize, format, i % 5L);
                AbstractBaseRecord read = format.newRecord();
                try {
                    this.writeRecord(written, format, storeFile, recordSize, idSequence);
                    this.readAndVerifyRecord(written, (R)read, format, key, storeFile, recordSize);
                    idSequence.reset();
                    continue;
                }
                catch (Throwable t) {
                    Exceptions.setMessage((Throwable)t, (String)(t.getMessage() + " : written:" + written + ", read:" + read + ", seed:" + random.seed() + ", iteration:" + i));
                    throw t;
                }
            }
        }
    }

    private <R extends AbstractBaseRecord> void readAndVerifyRecord(R written, R read, RecordFormat<R> format, RecordKey<R> key, PagedFile storeFile, int recordSize) throws IOException {
        try (PageCursor cursor = storeFile.io(0L, 1);){
            this.assertedNext(cursor);
            read.setId(written.getId());
            int offset = Math.toIntExact(written.getId() * (long)recordSize);
            do {
                cursor.setOffset(offset);
                format.read(read, cursor, RecordLoad.NORMAL, recordSize);
            } while (cursor.shouldRetry());
            this.assertWithinBounds(written, cursor, "reading");
            cursor.checkAndClearCursorException();
            if (written.inUse()) {
                Assert.assertEquals((Object)written.inUse(), (Object)read.inUse());
                Assert.assertEquals((long)written.getId(), (long)read.getId());
                Assert.assertEquals((long)written.getSecondaryUnitId(), (long)read.getSecondaryUnitId());
                key.assertRecordsEquals(written, read);
            } else {
                Assert.assertEquals((Object)written.inUse(), (Object)read.inUse());
            }
        }
    }

    private <R extends AbstractBaseRecord> void writeRecord(R record, RecordFormat<R> format, PagedFile storeFile, int recordSize, BatchingIdSequence idSequence) throws IOException {
        try (PageCursor cursor = storeFile.io(0L, 2);){
            this.assertedNext(cursor);
            if (record.inUse()) {
                format.prepare(record, recordSize, (IdSequence)idSequence);
            }
            int offset = Math.toIntExact(record.getId() * (long)recordSize);
            cursor.setOffset(offset);
            format.write(record, cursor, recordSize);
            this.assertWithinBounds(record, cursor, "writing");
        }
    }

    private <R extends AbstractBaseRecord> void assertWithinBounds(R record, PageCursor cursor, String operation) {
        if (cursor.checkAndClearBoundsFlag()) {
            Assert.fail((String)("Out-of-bounds when " + operation + " record " + record));
        }
    }

    private void assertedNext(PageCursor cursor) throws IOException {
        Assert.assertTrue((boolean)cursor.next());
    }

    private long idSureToBeOnTheNextPage(int pageSize, int recordSize) {
        return (pageSize + 100) / recordSize;
    }
}

