/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

@RunWith(value=Parameterized.class)
public class RelationshipGroupRecordFormatTest {
    private final RecordFormat<RelationshipGroupRecord> format;
    private final int recordSize;

    @Parameterized.Parameters
    public static Collection<RecordFormats> formats() {
        return Arrays.asList(StandardV2_1.RECORD_FORMATS, StandardV2_2.RECORD_FORMATS, StandardV2_3.RECORD_FORMATS, StandardV3_0.RECORD_FORMATS);
    }

    public RelationshipGroupRecordFormatTest(RecordFormats formats) {
        this.format = formats.relationshipGroup();
        this.recordSize = this.format.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
    }

    @Test
    public void shouldReadUnsignedRelationshipTypeId() throws Exception {
        try (StubPageCursor cursor = new StubPageCursor(1L, this.recordSize * 10);){
            int offset = 10;
            cursor.next();
            RelationshipGroupRecord group = new RelationshipGroupRecord(2L).initialize(true, Short.MAX_VALUE + offset, 1L, 2L, 3L, 4L, 5L);
            cursor.setOffset(offset);
            this.format.write((AbstractBaseRecord)group, (PageCursor)cursor, this.recordSize);
            RelationshipGroupRecord read = new RelationshipGroupRecord(group.getId());
            cursor.setOffset(offset);
            this.format.read((AbstractBaseRecord)read, (PageCursor)cursor, RecordLoad.NORMAL, this.recordSize);
            Assert.assertEquals((Object)group, (Object)read);
        }
    }
}

