/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;

public class LogPruneStrategyFactoryTest {
    @Test
    public void testLogPruneThresholdsByType() throws Exception {
        FileSystemAbstraction fsa = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Assert.assertThat((Object)LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fsa, (ThresholdConfigParser.ThresholdConfigValue)new ThresholdConfigParser.ThresholdConfigValue("files", 25L), (String)""), (Matcher)Matchers.instanceOf(FileCountThreshold.class));
        Assert.assertThat((Object)LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fsa, (ThresholdConfigParser.ThresholdConfigValue)new ThresholdConfigParser.ThresholdConfigValue("size", 16000L), (String)""), (Matcher)Matchers.instanceOf(FileSizeThreshold.class));
        Assert.assertThat((Object)LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fsa, (ThresholdConfigParser.ThresholdConfigValue)new ThresholdConfigParser.ThresholdConfigValue("txs", 4000L), (String)""), (Matcher)Matchers.instanceOf(EntryCountThreshold.class));
        Assert.assertThat((Object)LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fsa, (ThresholdConfigParser.ThresholdConfigValue)new ThresholdConfigParser.ThresholdConfigValue("entries", 4000L), (String)""), (Matcher)Matchers.instanceOf(EntryCountThreshold.class));
        Assert.assertThat((Object)LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fsa, (ThresholdConfigParser.ThresholdConfigValue)new ThresholdConfigParser.ThresholdConfigValue("hours", 100L), (String)""), (Matcher)Matchers.instanceOf(EntryTimespanThreshold.class));
        Assert.assertThat((Object)LogPruneStrategyFactory.getThresholdByType((FileSystemAbstraction)fsa, (ThresholdConfigParser.ThresholdConfigValue)new ThresholdConfigParser.ThresholdConfigValue("days", 100000L), (String)""), (Matcher)Matchers.instanceOf(EntryTimespanThreshold.class));
    }
}

