/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class RelationshipGroupCommandV2_2Test {
    @Test
    public void shouldSerializeAndDeserializeUnusedRecords() throws Exception {
        RelationshipGroupRecord before = new RelationshipGroupRecord(10L, 12, 13L, 14L, 15L, 16L, 17L, true);
        RelationshipGroupRecord after = new RelationshipGroupRecord(10L, 12);
        after.setInUse(false);
        this.assertSerializationWorksFor(new Command.RelationshipGroupCommand(before, after));
    }

    @Test
    public void shouldSerializeCreatedRecord() throws Exception {
        RelationshipGroupRecord before = new RelationshipGroupRecord(10L, 12);
        before.setInUse(false);
        RelationshipGroupRecord after = new RelationshipGroupRecord(10L, 12, 13L, 14L, 15L, 16L, 17L, true);
        after.setCreated();
        this.assertSerializationWorksFor(new Command.RelationshipGroupCommand(before, after));
    }

    private void assertSerializationWorksFor(Command.RelationshipGroupCommand cmd) throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        cmd.serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV2_2 commandReader = new PhysicalLogCommandReaderV2_2();
        Command.RelationshipGroupCommand result = (Command.RelationshipGroupCommand)commandReader.read((ReadableChannel)channel);
        RelationshipGroupRecord recordBefore = (RelationshipGroupRecord)cmd.getBefore();
        RelationshipGroupRecord recordAfter = (RelationshipGroupRecord)result.getAfter();
        MatcherAssert.assertThat((Object)recordBefore.getFirstIn(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstIn()));
        MatcherAssert.assertThat((Object)recordBefore.getFirstOut(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstOut()));
        MatcherAssert.assertThat((Object)recordBefore.getFirstLoop(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstLoop()));
        MatcherAssert.assertThat((Object)recordBefore.getNext(), (Matcher)IsEqual.equalTo((Object)recordAfter.getNext()));
        MatcherAssert.assertThat((Object)recordBefore.getOwningNode(), (Matcher)IsEqual.equalTo((Object)recordAfter.getOwningNode()));
        MatcherAssert.assertThat((Object)recordBefore.getPrev(), (Matcher)IsEqual.equalTo((Object)recordAfter.getPrev()));
        MatcherAssert.assertThat((Object)recordBefore.getType(), (Matcher)IsEqual.equalTo((Object)recordAfter.getType()));
    }
}

