/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public class DependenciesTest {
    @Test
    public void givenSatisfiedTypeWhenResolveWithTypeThenInstanceReturned() throws Exception {
        Dependencies dependencies = new Dependencies();
        String foo = "foo";
        dependencies.satisfyDependency((Object)foo);
        String instance = (String)dependencies.resolveDependency(String.class);
        Assert.assertThat((Object)instance, (Matcher)Matchers.equalTo((Object)foo));
    }

    @Test
    public void givenSatisfiedTypeWhenResolveWithSuperTypeThenInstanceReturned() throws Exception {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        AbstractList instance = (AbstractList)dependencies.resolveDependency(AbstractList.class);
        Assert.assertThat((Object)instance, (Matcher)Matchers.equalTo(foo));
    }

    @Test
    public void givenSatisfiedTypeWhenResolveWithInterfaceThenInstanceReturned() throws Exception {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        List instance = (List)dependencies.resolveDependency(List.class);
        Assert.assertThat((Object)instance, (Matcher)Matchers.equalTo(foo));
    }

    @Test
    public void givenSatisfiedTypeWhenResolveWithSubInterfaceThenInstanceReturned() throws Exception {
        Dependencies dependencies = new Dependencies();
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        Collection instance = (Collection)dependencies.resolveDependency(Collection.class);
        Assert.assertThat((Object)instance, (Matcher)Matchers.equalTo(foo));
    }

    @Test
    public void givenSatisfiedTypeInParentWhenResolveWithTypeInEmptyDependenciesThenInstanceReturned() throws Exception {
        Dependencies parent = new Dependencies();
        Dependencies dependencies = new Dependencies((DependencyResolver)parent);
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        Collection instance = (Collection)dependencies.resolveDependency(Collection.class);
        Assert.assertThat((Object)instance, (Matcher)Matchers.equalTo(foo));
    }

    @Test
    public void givenSatisfiedTypeInParentAndDependenciesWhenResolveWithTypeInDependenciesThenInstanceReturned() throws Exception {
        Dependencies parent = new Dependencies();
        Dependencies dependencies = new Dependencies((DependencyResolver)parent);
        ArrayList foo = new ArrayList();
        dependencies.satisfyDependency(foo);
        parent.satisfyDependency(new ArrayList());
        Collection instance = (Collection)dependencies.resolveDependency(Collection.class);
        Assert.assertThat((Object)instance, (Matcher)Matchers.equalTo(foo));
    }

    @Test
    public void givenEmptyDependenciesWhenResolveWithTypeThenException() throws Exception {
        Dependencies dependencies = new Dependencies();
        try {
            dependencies.resolveDependency(Collection.class);
            junit.framework.Assert.fail();
        }
        catch (UnsatisfiedDependencyException unsatisfiedDependencyException) {
            // empty catch block
        }
    }
}

