/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.Property;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;

public class GraphMock {
    public static Label[] labels(String ... names) {
        Label[] labels = new Label[names.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Label.label((String)names[i]);
        }
        return labels;
    }

    public static Node node(long id, Label[] labels, Property ... properties) {
        return GraphMock.mockNode(id, labels, Properties.properties(properties));
    }

    public static Node node(long id, Properties properties, String ... labels) {
        return GraphMock.mockNode(id, GraphMock.labels(labels), properties);
    }

    public static Relationship relationship(long id, Properties properties, Node start, String type, Node end) {
        return GraphMock.mockRelationship(id, start, type, end, properties);
    }

    public static Relationship relationship(long id, Node start, String type, Node end, Property ... properties) {
        return GraphMock.mockRelationship(id, start, type, end, Properties.properties(properties));
    }

    public static Link link(Relationship relationship, Node node) {
        return Link.link(relationship, node);
    }

    public static Path path(Node node, Link ... links) {
        ArrayList<Node> nodes = new ArrayList<Node>(links.length + 1);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>(links.length);
        ArrayList<Object> mixed = new ArrayList<Object>(links.length * 2 + 1);
        nodes.add(node);
        mixed.add(node);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.startNode()).thenReturn((Object)node);
        Relationship last = null;
        for (Link link : links) {
            last = link.relationship;
            relationships.add(last);
            mixed.add(last);
            node = link.checkNode(node);
            nodes.add(node);
            mixed.add(node);
        }
        Mockito.when((Object)path.endNode()).thenReturn((Object)node);
        Mockito.when((Object)path.iterator()).thenAnswer(GraphMock.withIteratorOf(mixed));
        Mockito.when((Object)path.nodes()).thenReturn(nodes);
        Mockito.when((Object)path.relationships()).thenReturn(relationships);
        Mockito.when((Object)path.lastRelationship()).thenReturn((Object)last);
        Mockito.when((Object)path.length()).thenReturn((Object)links.length);
        Mockito.when((Object)path.reverseNodes()).thenReturn((Object)Iterables.reverse(nodes));
        Mockito.when((Object)path.reverseRelationships()).thenReturn((Object)Iterables.reverse(relationships));
        return path;
    }

    private static <T> Answer<Iterator<T>> withIteratorOf(final Iterable<T> iterable) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocation) throws Throwable {
                return iterable.iterator();
            }
        };
    }

    private static Node mockNode(long id, Label[] labels, Properties properties) {
        Node node = GraphMock.mockPropertyContainer(Node.class, properties);
        Mockito.when((Object)node.getId()).thenReturn((Object)id);
        Mockito.when((Object)node.getLabels()).thenReturn((Object)Iterables.asResourceIterable(Arrays.asList(labels)));
        return node;
    }

    private static Relationship mockRelationship(long id, Node start, String type, Node end, Properties properties) {
        Relationship relationship = GraphMock.mockPropertyContainer(Relationship.class, properties);
        Mockito.when((Object)relationship.getId()).thenReturn((Object)id);
        Mockito.when((Object)relationship.getStartNode()).thenReturn((Object)start);
        Mockito.when((Object)relationship.getEndNode()).thenReturn((Object)end);
        Mockito.when((Object)relationship.getType()).thenReturn((Object)RelationshipType.withName((String)type));
        return relationship;
    }

    private static <T extends PropertyContainer> T mockPropertyContainer(Class<T> type, Properties properties) {
        PropertyContainer container = (PropertyContainer)Mockito.mock(type);
        Mockito.when((Object)container.getProperty(Matchers.anyString())).thenAnswer((Answer)properties);
        Mockito.when((Object)container.getProperty(Matchers.anyString(), Matchers.any())).thenAnswer((Answer)properties);
        Mockito.when((Object)container.getPropertyKeys()).thenReturn((Object)properties);
        Mockito.when((Object)container.getAllProperties()).thenReturn(properties.getProperties());
        return (T)container;
    }
}

