/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.ExternalResource;
import org.neo4j.test.rule.TestDirectory;

public class NeoStoresRule
extends ExternalResource {
    private final Class<?> testClass;
    private NeoStores neoStores;
    private EphemeralFileSystemAbstraction efs;
    private PageCache pageCache;
    private final StoreType[] stores;

    public NeoStoresRule(Class<?> testClass, StoreType ... stores) {
        this.testClass = testClass;
        this.stores = stores;
    }

    public NeoStores open(String ... config) throws IOException {
        Config configuration = new Config(MapUtil.stringMap((String[])config));
        RecordFormats formats = RecordFormatSelector.selectForConfig((Config)configuration, (LogProvider)NullLogProvider.getInstance());
        return this.open(formats, config);
    }

    public NeoStores open(RecordFormats format, String ... config) throws IOException {
        this.efs = new EphemeralFileSystemAbstraction();
        Config conf = new Config(MapUtil.stringMap((String[])config));
        this.pageCache = NeoStoresRule.getOrCreatePageCache(conf, (FileSystemAbstraction)this.efs);
        return this.open((FileSystemAbstraction)this.efs, this.pageCache, format, config);
    }

    public NeoStores open(FileSystemAbstraction fs, PageCache pageCache, RecordFormats format, String ... config) throws IOException {
        assert (this.neoStores == null) : "Already opened";
        TestDirectory testDirectory = TestDirectory.testDirectory(this.testClass, (FileSystemAbstraction)fs);
        File storeDir = testDirectory.makeGraphDbDir();
        Config configuration = new Config(MapUtil.stringMap((String[])config));
        StoreFactory storeFactory = new StoreFactory(storeDir, configuration, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs), pageCache, fs, format, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = this.stores.length == 0 ? storeFactory.openAllNeoStores(true) : storeFactory.openNeoStores(true, this.stores);
        return this.neoStores;
    }

    @Override
    protected void after(boolean successful) throws Throwable {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
        if (this.pageCache != null) {
            this.pageCache.close();
        }
        if (this.efs != null) {
            this.efs.shutdown();
        }
    }

    private static PageCache getOrCreatePageCache(Config config, FileSystemAbstraction fs) {
        NullLog log = NullLog.getInstance();
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fs, config, PageCacheTracer.NULL, (Log)log);
        return pageCacheFactory.getOrCreatePageCache();
    }
}

