/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.test.rule.ExternalResource;

public class PageCacheRule
extends ExternalResource {
    private PageCache pageCache;
    private final boolean automaticallyProduceInconsistentReads;

    public PageCacheRule() {
        this.automaticallyProduceInconsistentReads = true;
    }

    public PageCacheRule(boolean automaticallyProduceInconsistentReads) {
        this.automaticallyProduceInconsistentReads = automaticallyProduceInconsistentReads;
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(GraphDatabaseSettings.pagecache_memory.name(), "8M");
        return this.getPageCache(fs, new Config(settings));
    }

    public PageCache getPageCache(FileSystemAbstraction fs, Config config) {
        return this.getPageCache(fs, PageCacheTracer.NULL, config);
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheTracer tracer, Config config) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (Exception e) {
                throw new AssertionError("Failed to stop existing PageCache prior to creating a new one", e);
            }
        }
        this.pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (PageCacheTracer)tracer, (Config)config);
        if (this.automaticallyProduceInconsistentReads) {
            return this.withInconsistentReads(this.pageCache);
        }
        return this.pageCache;
    }

    @Override
    protected void after(boolean success) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (Exception e) {
                throw new AssertionError("Failed to stop PageCache after test", e);
            }
            this.pageCache = null;
        }
    }

    public PageCache withInconsistentReads(PageCache pageCache, AtomicBoolean nextReadIsInconsistent) {
        AtomicBooleanInconsistentReadAdversary adversary = new AtomicBooleanInconsistentReadAdversary(nextReadIsInconsistent);
        return new AdversarialPageCache(pageCache, (Adversary)adversary);
    }

    public PageCache withInconsistentReads(PageCache pageCache) {
        RandomInconsistentReadAdversary adversary = new RandomInconsistentReadAdversary();
        return new AdversarialPageCache(pageCache, (Adversary)adversary);
    }

    private static class RandomInconsistentReadAdversary
    implements Adversary {
        private RandomInconsistentReadAdversary() {
        }

        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return ThreadLocalRandom.current().nextBoolean();
        }
    }

    private static class AtomicBooleanInconsistentReadAdversary
    implements Adversary {
        final AtomicBoolean nextReadIsInconsistent;

        AtomicBooleanInconsistentReadAdversary(AtomicBoolean nextReadIsInconsistent) {
            this.nextReadIsInconsistent = nextReadIsInconsistent;
        }

        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return this.nextReadIsInconsistent.getAndSet(false);
        }
    }
}

