/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.fs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;

public class EphemeralFileSystemRule
extends ExternalResource
implements Supplier<FileSystemAbstraction>,
FileSystemAbstraction {
    private EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();

    protected void after() {
        this.fs.shutdown();
    }

    @Override
    public final EphemeralFileSystemAbstraction get() {
        return this.fs;
    }

    public EphemeralFileSystemAbstraction snapshot(Runnable action) {
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        try {
            action.run();
        }
        finally {
            this.fs.shutdown();
            this.fs = snapshot;
        }
        return this.fs;
    }

    public void clear() {
        this.fs.shutdown();
        this.fs = new EphemeralFileSystemAbstraction();
    }

    public static Runnable shutdownDbAction(GraphDatabaseService db) {
        return () -> db.shutdown();
    }

    public int hashCode() {
        return this.fs.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fs.equals(obj);
    }

    public void crash() {
        this.fs.crash();
    }

    public void shutdown() {
        this.fs.shutdown();
    }

    public void assertNoOpenFiles() throws Exception {
        this.fs.assertNoOpenFiles();
    }

    public void dumpZip(OutputStream output) throws IOException {
        this.fs.dumpZip(output);
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        return this.fs.open(fileName, mode);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return this.fs.openAsOutputStream(fileName, append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return this.fs.openAsInputStream(fileName);
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return this.fs.openAsReader(fileName, charset);
    }

    public String toString() {
        return this.fs.toString();
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return this.fs.openAsWriter(fileName, charset, append);
    }

    public StoreChannel create(File fileName) throws IOException {
        return this.fs.create(fileName);
    }

    public long getFileSize(File fileName) {
        return this.fs.getFileSize(fileName);
    }

    public boolean fileExists(File file) {
        return this.fs.fileExists(file);
    }

    public boolean isDirectory(File file) {
        return this.fs.isDirectory(file);
    }

    public boolean mkdir(File directory) {
        return this.fs.mkdir(directory);
    }

    public void mkdirs(File directory) {
        this.fs.mkdirs(directory);
    }

    public boolean deleteFile(File fileName) {
        return this.fs.deleteFile(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.fs.deleteRecursively(directory);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.fs.renameFile(from, to, copyOptions);
    }

    public File[] listFiles(File directory) {
        return this.fs.listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.fs.listFiles(directory, filter);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.fs.moveToDirectory(file, toDirectory);
    }

    public void copyFile(File from, File to) throws IOException {
        this.fs.copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.fs.copyRecursively(fromDirectory, toDirectory);
    }

    public EphemeralFileSystemAbstraction snapshot() {
        return this.fs.snapshot();
    }

    public void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to) throws IOException {
        this.fs.copyRecursivelyFromOtherFs(from, fromFs, to);
    }

    public long checksum() {
        return this.fs.checksum();
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return (K)this.fs.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public void truncate(File file, long size) throws IOException {
        this.fs.truncate(file, size);
    }

    public long lastModifiedTime(File file) throws IOException {
        return this.fs.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(File file) throws IOException {
        this.fs.deleteFileOrThrow(file);
    }
}

