/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.unsafe.impl.batchimport.Configuration;

public class ConfigurationTest {
    @Test
    public void shouldOverrideBigPageCacheMemorySettingContainingUnit() throws Exception {
        Config dbConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "2g"}));
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assert.assertEquals((long)Configuration.MAX_PAGE_CACHE_MEMORY, (long)memory);
    }

    @Test
    public void shouldOverrideSmallPageCacheMemorySettingContainingUnit() throws Exception {
        long overridden = Settings.parseLongWithUnit((String)"10m");
        Config dbConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), String.valueOf(overridden)}));
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assert.assertEquals((long)overridden, (long)memory);
    }

    @Test
    public void shouldParseDefaultPageCacheMemorySetting() throws Exception {
        Configuration config = Configuration.DEFAULT;
        long memory = config.pageCacheMemory();
        long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
        Assert.assertTrue((boolean)this.within(memory, heuristic, Configuration.MAX_PAGE_CACHE_MEMORY));
    }

    @Test
    public void shouldCalculateBigPageSizeForBiggerMemory() throws Exception {
        Configuration config = this.configWithPageCacheMemory(ByteUnit.mebiBytes((long)240L));
        int pageSize = config.pageSize();
        Assert.assertEquals((long)ByteUnit.mebiBytes((long)4L), (long)pageSize);
    }

    @Test
    public void shouldCalculateSmallPageSizeForSmallerMemory() throws Exception {
        Configuration config = this.configWithPageCacheMemory(ByteUnit.mebiBytes((long)100L));
        int pageSize = config.pageSize();
        Assert.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)pageSize);
    }

    @Test
    public void shouldNotGoLowerThan8kPageSizeForSmallMemory() throws Exception {
        Configuration config = this.configWithPageCacheMemory(ByteUnit.kibiBytes((long)240L));
        int pageSize = config.pageSize();
        Assert.assertEquals((long)ByteUnit.kibiBytes((long)8L), (long)pageSize);
    }

    @Test
    public void shouldNotGoHigherThan8mPageSizeForBigMemory() throws Exception {
        Configuration config = this.configWithPageCacheMemory(ByteUnit.mebiBytes((long)700L));
        int pageSize = config.pageSize();
        Assert.assertEquals((long)ByteUnit.mebiBytes((long)8L), (long)pageSize);
    }

    private boolean within(long value, long firstBound, long otherBound) {
        return value >= Math.min(firstBound, otherBound) && value <= Math.max(firstBound, otherBound);
    }

    private Configuration configWithPageCacheMemory(final long bytes) {
        return new Configuration.Default(){

            public long pageCacheMemory() {
                return bytes;
            }
        };
    }
}

