/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.PerTypeRelationshipSplitter;
import org.neo4j.unsafe.impl.batchimport.input.SimpleInputIteratorWrapper;

public class PerTypeRelationshipSplitterTest {
    @Rule
    public final RandomRule random = new RandomRule().withSeed(1460373085111L);
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldReturnTypesOneByOne() throws Exception {
        Collection<InputRelationship> expected = this.randomRelationships();
        InputIterable<InputRelationship> relationships = SimpleInputIteratorWrapper.wrap("test", expected);
        InputCache inputCache = new InputCache((FileSystemAbstraction)new DefaultFileSystemAbstraction(), this.directory.directory(), StandardV3_0.RECORD_FORMATS, Configuration.DEFAULT);
        PerTypeRelationshipSplitter perType = new PerTypeRelationshipSplitter(relationships.iterator(), this.types(expected), type -> false, type -> Integer.parseInt(type.toString()), inputCache);
        HashSet<Object> all = new HashSet<Object>();
        while (perType.hasNext()) {
            InputIterator relationshipsOfThisType = (InputIterator)perType.next();
            Throwable throwable = null;
            try {
                Object type2 = perType.currentType();
                Collection<Object> expectedRelationshipsOfThisType = this.nodesOf(Iterators.filter(relationship -> relationship.typeAsObject().equals(type2), expected.iterator()));
                Assert.assertEquals(expectedRelationshipsOfThisType, this.nodesOf((Iterator<InputRelationship>)relationshipsOfThisType));
                all.addAll(expectedRelationshipsOfThisType);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (relationshipsOfThisType == null) continue;
                if (throwable != null) {
                    try {
                        relationshipsOfThisType.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                relationshipsOfThisType.close();
            }
        }
        Assert.assertEquals(this.nodesOf(expected.iterator()), all);
        inputCache.close();
    }

    private Collection<Object> nodesOf(Iterator<InputRelationship> relationship) {
        HashSet<Object> nodes = new HashSet<Object>();
        while (relationship.hasNext()) {
            nodes.add(relationship.next().startNode());
        }
        return nodes;
    }

    private Object[] types(Collection<InputRelationship> expected) {
        HashSet<Object> types = new HashSet<Object>();
        for (InputRelationship relationship : expected) {
            types.add(relationship.typeAsObject());
        }
        return types.toArray();
    }

    private Collection<InputRelationship> randomRelationships() {
        ArrayList<InputRelationship> result = new ArrayList<InputRelationship>();
        int count = 100;
        Group group = Group.GLOBAL;
        boolean typeIds = this.random.nextBoolean();
        for (int i = 0; i < count; ++i) {
            int typeId = this.random.nextInt(5);
            Long node = i;
            InputRelationship relationship = new InputRelationship("test", (long)i, (long)i, InputEntity.NO_PROPERTIES, null, group, (Object)node, group, (Object)node, typeIds ? null : String.valueOf(typeId), typeIds ? Integer.valueOf(typeId) : null);
            result.add(relationship);
        }
        return result;
    }
}

