/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.participant.StoreSourceTraceability;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

abstract class StoreScanAsInputIterable<INPUT extends InputEntity, RECORD extends AbstractBaseRecord>
implements InputIterable<INPUT> {
    private final RecordStore<RECORD> store;
    private final RecordCursor<RECORD> cursor;
    private final StoreSourceTraceability traceability;

    public StoreScanAsInputIterable(RecordStore<RECORD> store) {
        this.store = store;
        this.cursor = store.newRecordCursor(store.newRecord());
        this.traceability = new StoreSourceTraceability(store.toString(), store.getRecordSize());
    }

    @Override
    public InputIterator<INPUT> iterator() {
        this.cursor.acquire(0L, RecordLoad.CHECK);
        return new InputIterator.Adapter<INPUT>(){
            private final long highId;
            private long id;
            {
                this.highId = StoreScanAsInputIterable.this.store.getHighId();
            }

            @Override
            public String sourceDescription() {
                return StoreScanAsInputIterable.this.traceability.sourceDescription();
            }

            @Override
            public long lineNumber() {
                return StoreScanAsInputIterable.this.traceability.lineNumber();
            }

            @Override
            public long position() {
                return StoreScanAsInputIterable.this.traceability.position();
            }

            @Override
            public void close() {
                StoreScanAsInputIterable.this.cursor.close();
            }

            protected INPUT fetchNextOrNull() {
                while (this.id < this.highId) {
                    if (!StoreScanAsInputIterable.this.cursor.next(this.id++)) continue;
                    AbstractBaseRecord record = (AbstractBaseRecord)StoreScanAsInputIterable.this.cursor.get();
                    StoreScanAsInputIterable.this.traceability.atId(record.getId());
                    return StoreScanAsInputIterable.this.inputEntityOf(record);
                }
                return null;
            }
        };
    }

    protected abstract INPUT inputEntityOf(RECORD var1);

    @Override
    public boolean supportsMultiplePasses() {
        return true;
    }
}

