/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public class Dependencies
extends DependencyResolver.Adapter
implements DependencySatisfier {
    private final Supplier<DependencyResolver> parent;
    private final Map<Class<?>, List<?>> typeDependencies = new HashMap();

    public Dependencies() {
        this.parent = null;
    }

    public Dependencies(DependencyResolver parent) {
        this.parent = () -> parent;
    }

    public Dependencies(Supplier<DependencyResolver> parent) {
        this.parent = parent;
    }

    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        DependencyResolver dependencyResolver;
        List<?> options = this.typeDependencies.get(type);
        if (options != null) {
            return (T)selector.select(type, options);
        }
        if (this.parent != null && (dependencyResolver = this.parent.get()) != null) {
            return (T)dependencyResolver.resolveDependency(type, selector);
        }
        throw new UnsatisfiedDependencyException(type);
    }

    public <T> Supplier<T> provideDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        return () -> this.resolveDependency(type, selector);
    }

    public <T> Supplier<T> provideDependency(Class<T> type) {
        return () -> this.resolveDependency(type);
    }

    @Override
    public <T> T satisfyDependency(T dependency) {
        Class<?> type = dependency.getClass();
        do {
            List<?> deps;
            if ((deps = this.typeDependencies.get(type)) == null) {
                deps = new ArrayList();
                this.typeDependencies.put(type, deps);
            }
            deps.add(dependency);
            Class[] interfaces = type.getInterfaces();
            this.addInterfaces(interfaces, dependency);
        } while ((type = type.getSuperclass()) != null);
        return dependency;
    }

    public void satisfyDependencies(Object ... dependencies) {
        for (Object dependency : dependencies) {
            this.satisfyDependency(dependency);
        }
    }

    private <T> void addInterfaces(Class[] interfaces, T dependency) {
        for (Class type : interfaces) {
            List<?> deps = this.typeDependencies.get(type);
            if (deps == null) {
                deps = new ArrayList();
                this.typeDependencies.put(type, deps);
            }
            deps.add(dependency);
            this.addInterfaces(type.getInterfaces(), dependency);
        }
    }
}

