/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class RelationshipPreparationStep
extends ProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final IdMapper idMapper;

    public RelationshipPreparationStep(StageControl control, org.neo4j.unsafe.impl.batchimport.Configuration config, IdMapper idMapper) {
        super(control, "PREPARE", (Configuration)config, 0, new StatsProvider[0]);
        this.idMapper = idMapper;
    }

    @Override
    protected void process(Batch<InputRelationship, RelationshipRecord> batch, BatchSender sender) {
        InputRelationship[] input = (InputRelationship[])batch.input;
        batch.ids = new long[input.length * 2];
        long[] ids = batch.ids;
        for (int i = 0; i < input.length; ++i) {
            InputRelationship batchRelationship = input[i];
            ids[i * 2] = this.idMapper.get(batchRelationship.startNode(), batchRelationship.startNodeGroup());
            ids[i * 2 + 1] = this.idMapper.get(batchRelationship.endNode(), batchRelationship.endNodeGroup());
        }
        sender.send(batch);
    }
}

