/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;

public class ListenAddressSettingsTest {
    private static Setting<ListenSocketAddress> legacy_address_setting = Settings.listenAddress((String)"address", (int)1234);
    private static Setting<ListenSocketAddress> listen_address_setting = Settings.legacyFallback(legacy_address_setting, (Setting)Settings.listenAddress((String)"listen_address", (int)1234));

    @Test
    public void shouldParseExplicitSettingValueWhenProvided() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_listen_address.name(), "server1.example.com"}));
        config.augment(MapUtil.stringMap((String[])new String[]{listen_address_setting.name(), "server1.internal:4000"}));
        ListenSocketAddress listenSocketAddress = (ListenSocketAddress)config.get(listen_address_setting);
        Assert.assertEquals((Object)"server1.internal", (Object)listenSocketAddress.getHostname());
        Assert.assertEquals((long)4000L, (long)listenSocketAddress.getPort());
    }

    @Test
    public void shouldFallbackToLegacySettingWhenOnlyValueProvided() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_listen_address.name(), "server1.example.com"}));
        config.augment(MapUtil.stringMap((String[])new String[]{legacy_address_setting.name(), "server1.internal:4000"}));
        ListenSocketAddress listenSocketAddress = (ListenSocketAddress)config.get(listen_address_setting);
        Assert.assertEquals((Object)"server1.internal", (Object)listenSocketAddress.getHostname());
        Assert.assertEquals((long)4000L, (long)listenSocketAddress.getPort());
    }

    @Test
    public void shouldCombineDefaultHostnameWithSettingSpecificPortWhenNoValueProvided() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_listen_address.name(), "server1.example.com"}));
        ListenSocketAddress listenSocketAddress = (ListenSocketAddress)config.get(listen_address_setting);
        Assert.assertEquals((Object)"server1.example.com", (Object)listenSocketAddress.getHostname());
        Assert.assertEquals((long)1234L, (long)listenSocketAddress.getPort());
    }

    @Test
    public void shouldCombineDefaultHostnameWithExplicitPortWhenOnlyAPortProvided() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_listen_address.name(), "server1.example.com"}));
        config.augment(MapUtil.stringMap((String[])new String[]{listen_address_setting.name(), ":4000"}));
        ListenSocketAddress listenSocketAddress = (ListenSocketAddress)config.get(listen_address_setting);
        Assert.assertEquals((Object)"server1.example.com", (Object)listenSocketAddress.getHostname());
        Assert.assertEquals((long)4000L, (long)listenSocketAddress.getPort());
    }
}

