/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.query.QuerySource;

public class ExecutingQueryListTest {
    @Test
    public void removingTheLastQueryReturnsAnEmptyList() {
        ExecutingQuery aQuery = this.createExecutingQuery(1, "query");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(aQuery);
        ExecutingQueryList result = list.remove(aQuery);
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)ExecutingQueryList.EMPTY));
    }

    @Test
    public void addingQueriesKeepsInsertOrder() {
        ExecutingQuery query1 = this.createExecutingQuery(1, "query1");
        ExecutingQuery query2 = this.createExecutingQuery(2, "query2");
        ExecutingQuery query3 = this.createExecutingQuery(3, "query3");
        ExecutingQuery query4 = this.createExecutingQuery(4, "query4");
        ExecutingQuery query5 = this.createExecutingQuery(5, "query5");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(query1).push(query2).push(query3).push(query4).push(query5);
        List result = list.queries().collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList(query5, query4, query3, query2, query1)));
    }

    @Test
    public void removingQueryInTheMiddleKeepsOrder() {
        ExecutingQuery query1 = this.createExecutingQuery(1, "query1");
        ExecutingQuery query2 = this.createExecutingQuery(2, "query2");
        ExecutingQuery query3 = this.createExecutingQuery(3, "query3");
        ExecutingQuery query4 = this.createExecutingQuery(4, "query4");
        ExecutingQuery query5 = this.createExecutingQuery(5, "query5");
        ExecutingQueryList list = ExecutingQueryList.EMPTY.push(query1).push(query2).push(query3).push(query4).push(query5);
        List result = list.remove(query3).queries().collect(Collectors.toList());
        Assert.assertThat(result, (Matcher)Matchers.equalTo(Arrays.asList(query5, query4, query2, query1)));
    }

    private ExecutingQuery createExecutingQuery(int queryId, String query) {
        return new ExecutingQuery((long)queryId, QuerySource.UNKNOWN, "me", query, Collections.emptyMap(), 10L, Collections.emptyMap());
    }
}

