/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.function.IntPredicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.IndexSample;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleIndexPopulatorTest {
    @Mock
    private IndexStoreView indexStoreView;
    @Mock
    private StoreScan storeScan;
    @Mock(answer=Answers.RETURNS_MOCKS)
    private LogProvider logProvider;
    @InjectMocks
    private MultipleIndexPopulator multipleIndexPopulator;

    @Before
    public void setUp() {
        Mockito.when((Object)this.indexStoreView.visitNodes((int[])Matchers.any(int[].class), (IntPredicate)Matchers.any(IntPredicate.class), (Visitor)Matchers.any(Visitor.class), (Visitor)Matchers.any(Visitor.class))).thenReturn((Object)this.storeScan);
    }

    @Test
    public void testMultiplePopulatorsCreation() throws Exception {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    public void testMultiplePopulatorCreationFailure() throws IOException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        IndexPopulator indexPopulator3 = this.createIndexPopulator();
        ((IndexPopulator)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)indexPopulator3)).create();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.addPopulator(indexPopulator3, 3);
        this.multipleIndexPopulator.create();
        this.checkPopulatorFailure(indexPopulator1);
        this.checkPopulatorFailure(indexPopulator3);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    public void testHasPopulators() {
        Assert.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
        this.addPopulator(this.createIndexPopulator(), 42);
        Assert.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    public void testIndexAllNodes() {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.indexAllNodes();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).visitNodes((int[])Matchers.any(int[].class), (IntPredicate)Matchers.any(IntPredicate.class), (Visitor)Matchers.any(Visitor.class), (Visitor)Matchers.any(Visitor.class));
    }

    @Test
    public void testFailPopulator() throws IOException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.fail((Throwable)this.getPopulatorException());
        this.checkPopulatorFailure(indexPopulator1);
        this.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    public void testFailByPopulation() throws IOException {
        IndexDescriptor descriptor1 = new IndexDescriptor(1, 1);
        IndexDescriptor descriptor2 = new IndexDescriptor(2, 2);
        IndexPopulator populator1 = this.createIndexPopulator();
        IndexPopulator populator2 = this.createIndexPopulator();
        this.addPopulator(populator1, descriptor1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, descriptor2);
        this.multipleIndexPopulator.fail(population2, (Throwable)this.getPopulatorException());
        ((IndexPopulator)Mockito.verify((Object)populator1, (VerificationMode)Mockito.never())).markAsFailed(Matchers.anyString());
        this.checkPopulatorFailure(populator2);
    }

    @Test
    public void testFailByPopulationRemovesPopulator() throws IOException {
        IndexDescriptor descriptor1 = new IndexDescriptor(1, 1);
        IndexDescriptor descriptor2 = new IndexDescriptor(2, 2);
        IndexPopulator populator1 = this.createIndexPopulator();
        IndexPopulator populator2 = this.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation population1 = this.addPopulator(populator1, descriptor1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, descriptor2);
        this.multipleIndexPopulator.fail(population1, (Throwable)this.getPopulatorException());
        this.multipleIndexPopulator.fail(population2, (Throwable)this.getPopulatorException());
        this.checkPopulatorFailure(populator1);
        this.checkPopulatorFailure(populator2);
        Assert.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    public void testFailByNonExistingPopulation() throws IOException {
        IndexDescriptor descriptor = new IndexDescriptor(1, 1);
        MultipleIndexPopulator.IndexPopulation nonExistingPopulation = (MultipleIndexPopulator.IndexPopulation)Mockito.mock(MultipleIndexPopulator.IndexPopulation.class);
        IndexPopulator populator = this.createIndexPopulator();
        this.addPopulator(populator, descriptor);
        this.multipleIndexPopulator.fail(nonExistingPopulation, (Throwable)this.getPopulatorException());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).markAsFailed(Matchers.anyString());
    }

    @Test
    public void testVerifyDeferredConstraintFailure() throws Exception {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        IndexPopulator indexPopulator3 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.addPopulator(indexPopulator3, 3);
        ((IndexPopulator)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)indexPopulator2)).verifyDeferredConstraints((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        this.multipleIndexPopulator.verifyAllDeferredConstraints((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).verifyDeferredConstraints((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator3)).verifyDeferredConstraints((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        this.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    public void closeMultipleIndexPopulator() throws IOException, IndexEntryConflictException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        ((IndexPopulator)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)indexPopulator2)).close(true);
        this.multipleIndexPopulator.close(true);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(true);
        this.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    public void testFlipAfterPopulation() throws Exception {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        FlippableIndexProxy flipper1 = this.addPopulator(indexPopulator1, 1);
        FlippableIndexProxy flipper2 = this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.flipAfterPopulation();
        ((FlippableIndexProxy)Mockito.verify((Object)flipper1)).flip((Callable)Matchers.any(Callable.class), (FailedIndexProxyFactory)Matchers.any(FailedIndexProxyFactory.class));
        ((FlippableIndexProxy)Mockito.verify((Object)flipper2)).flip((Callable)Matchers.any(Callable.class), (FailedIndexProxyFactory)Matchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    public void populationsRemovedDuringFlip() throws Exception {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        Assert.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation();
        Assert.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    public void testCancelPopulation() throws IOException {
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.cancel();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView, (VerificationMode)Mockito.times((int)2))).replaceIndexCounts((IndexDescriptor)Matchers.any(IndexDescriptor.class), Matchers.eq((long)0L), Matchers.eq((long)0L), Matchers.eq((long)0L));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(false);
    }

    @Test
    public void testIndexFlip() throws IOException {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator1 = this.createIndexPopulator();
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1, flipper, failedIndexProxyFactory);
        this.addPopulator(indexPopulator2, 2, flipper, failedIndexProxyFactory);
        Mockito.when((Object)indexPopulator1.sampleResult()).thenThrow(new Throwable[]{this.getSampleError()});
        this.multipleIndexPopulator.indexAllNodes();
        this.multipleIndexPopulator.flipAfterPopulation();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false);
        ((FailedIndexProxyFactory)Mockito.verify((Object)failedIndexProxyFactory, (VerificationMode)Mockito.times((int)1))).create((Throwable)Matchers.any(RuntimeException.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(true);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).sampleResult();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).replaceIndexCounts((IndexDescriptor)Matchers.any(IndexDescriptor.class), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyLong());
    }

    @Test
    public void testMultiplePopulatorUpdater() throws IOException, IndexEntryConflictException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = this.createIndexPopulator(indexUpdater1);
        IndexPopulator indexPopulator2 = this.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        ((IndexPopulator)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)indexPopulator2)).newPopulatingUpdater((PropertyAccessor)Matchers.any(PropertyAccessor.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        NodePropertyUpdate propertyUpdate = this.createNodePropertyUpdate();
        multipleIndexUpdater.process(propertyUpdate);
        this.checkPopulatorFailure(indexPopulator2);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).process(propertyUpdate);
    }

    @Test
    public void testNonApplicableUpdaterDoNotUpdatePopulator() throws IOException, IndexEntryConflictException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = this.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 2);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        NodePropertyUpdate propertyUpdate = this.createNodePropertyUpdate();
        multipleIndexUpdater.process(propertyUpdate);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexUpdater1});
    }

    @Test
    public void testPropertyUpdateFailure() throws IOException, IndexEntryConflictException {
        NodePropertyUpdate propertyUpdate = this.createNodePropertyUpdate();
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = this.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)indexUpdater1)).process(propertyUpdate);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((PropertyAccessor)Mockito.mock(PropertyAccessor.class));
        multipleIndexUpdater.process(propertyUpdate);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).close();
        this.checkPopulatorFailure(indexPopulator1);
    }

    @Test
    public void testMultiplePropertyUpdateFailures() throws IOException, IndexEntryConflictException {
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        NodePropertyUpdate update1 = NodePropertyUpdate.add((long)1L, (int)1, (Object)"foo", (long[])new long[]{1L});
        NodePropertyUpdate update2 = NodePropertyUpdate.add((long)2L, (int)1, (Object)"bar", (long[])new long[]{1L});
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator populator = this.createIndexPopulator(updater);
        this.addPopulator(populator, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable)this.getPopulatorException()).when((Object)updater)).process((NodePropertyUpdate)Matchers.any(NodePropertyUpdate.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater(propertyAccessor);
        multipleIndexUpdater.process(update1);
        multipleIndexUpdater.process(update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process(update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).close();
        this.checkPopulatorFailure(populator);
    }

    private NodePropertyUpdate createNodePropertyUpdate() {
        return NodePropertyUpdate.add((long)1L, (int)1, null, (long[])new long[]{1L});
    }

    private RuntimeException getSampleError() {
        return new RuntimeException("sample error");
    }

    private IndexPopulator createIndexPopulator(IndexUpdater indexUpdater) throws IOException {
        IndexPopulator indexPopulator = this.createIndexPopulator();
        Mockito.when((Object)indexPopulator.newPopulatingUpdater((PropertyAccessor)Matchers.any(PropertyAccessor.class))).thenReturn((Object)indexUpdater);
        return indexPopulator;
    }

    private IndexPopulator createIndexPopulator() {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        return populator;
    }

    private IOException getPopulatorException() {
        return new IOException("something went wrong");
    }

    private void checkPopulatorFailure(IndexPopulator populator) throws IOException {
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(Matchers.startsWith((String)"java.io.IOException: something went wrong"));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(false);
    }

    private void addPopulator(IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        this.addPopulator(this.multipleIndexPopulator, indexPopulator, id, flippableIndexProxy, failedIndexProxyFactory);
    }

    private void addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        IndexDescriptor descriptor = (IndexDescriptor)Mockito.mock(IndexDescriptor.class);
        Mockito.when((Object)descriptor.getLabelId()).thenReturn((Object)id);
        Mockito.when((Object)descriptor.getPropertyKeyId()).thenReturn((Object)id);
        this.addPopulator(multipleIndexPopulator, descriptor, indexPopulator, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, IndexDescriptor descriptor) {
        return this.addPopulator(this.multipleIndexPopulator, indexPopulator, descriptor);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, IndexDescriptor descriptor) {
        return this.addPopulator(multipleIndexPopulator, descriptor, indexPopulator, (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class), (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return multipleIndexPopulator.addPopulator(indexPopulator, descriptor, (SchemaIndexProvider.Descriptor)Mockito.mock(SchemaIndexProvider.Descriptor.class), IndexConfiguration.NON_UNIQUE, flippableIndexProxy, failedIndexProxyFactory, "userIndexDescription");
    }

    private FlippableIndexProxy addPopulator(IndexPopulator indexPopulator, int id) {
        FlippableIndexProxy indexProxy = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        this.addPopulator(indexPopulator, id, indexProxy, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
        return indexProxy;
    }
}

