/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class TestDenseNodeRelChainPositionIT {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();

    @Test
    public void givenDenseNodeWhenAskForWrongDirectionThenIncorrectNrOfRelsReturned() throws Exception {
        Node node1;
        int denseNodeThreshold = Integer.parseInt(GraphDatabaseSettings.dense_node_threshold.getDefaultValue()) + 1;
        try (Transaction tx = this.db.beginTx();){
            node1 = this.db.createNode();
            Node node2 = this.db.createNode();
            for (int i = 0; i < denseNodeThreshold; ++i) {
                node1.createRelationshipTo(node2, RelationshipType.withName((String)"FOO"));
            }
            tx.success();
        }
        var4_3 = null;
        try (Transaction ignored = this.db.beginTx();){
            Node node1b = this.db.getNodeById(node1.getId());
            Iterable rels = node1b.getRelationships(Direction.INCOMING);
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)rels));
            Iterable rels2 = node1b.getRelationships(Direction.OUTGOING);
            Assert.assertEquals((long)denseNodeThreshold, (long)Iterables.count((Iterable)rels2));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }
}

