/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LockManagerImplTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldAllowGetReadWriteLocks() {
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockResource node2 = new LockResource((ResourceType)ResourceTypes.NODE, 2L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = new LockManagerImpl(new RagManager());
        Assert.assertTrue((boolean)lockManager.getReadLock((Object)node1, (Object)lockTransaction));
        Assert.assertTrue((boolean)lockManager.getReadLock((Object)node2, (Object)lockTransaction));
        Assert.assertTrue((boolean)lockManager.getWriteLock((Object)node2, (Object)lockTransaction));
        lockManager.releaseReadLock((Object)node1, (Object)lockTransaction);
        lockManager.releaseReadLock((Object)node2, (Object)lockTransaction);
        lockManager.releaseWriteLock((Object)node2, (Object)lockTransaction);
        int lockCount = this.countLocks(lockManager);
        Assert.assertEquals((long)0L, (long)lockCount);
    }

    @Test
    public void shouldNotBePossibleReleaseNotExistingLock() {
        LockResource node1 = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = new LockManagerImpl(new RagManager());
        this.expectedException.expect(LockNotFoundException.class);
        this.expectedException.expectMessage("Lock not found for: ");
        lockManager.releaseReadLock((Object)node1, (Object)lockTransaction);
    }

    @Test
    public void shouldCleanupNotUsedLocks() {
        LockResource node = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        LockManagerImpl lockManager = new LockManagerImpl(new RagManager());
        lockManager.getWriteLock((Object)node, (Object)lockTransaction);
        Assert.assertTrue((boolean)lockManager.tryReadLock((Object)node, (Object)lockTransaction));
        Assert.assertEquals((long)1L, (long)this.countLocks(lockManager));
        lockManager.releaseWriteLock((Object)node, (Object)lockTransaction);
        Assert.assertEquals((long)1L, (long)this.countLocks(lockManager));
        lockManager.releaseReadLock((Object)node, (Object)lockTransaction);
        Assert.assertEquals((long)0L, (long)this.countLocks(lockManager));
    }

    @Test
    public void shouldReleaseNotAcquiredLocks() {
        LockResource node = new LockResource((ResourceType)ResourceTypes.NODE, 1L);
        LockTransaction lockTransaction = new LockTransaction();
        RWLock rwLock = (RWLock)Mockito.mock(RWLock.class);
        MockedLockLockManager lockManager = new MockedLockLockManager(new RagManager(), rwLock);
        lockManager.tryReadLock(node, lockTransaction);
        Assert.assertEquals((long)0L, (long)this.countLocks(lockManager));
    }

    private RWLock getLockByResource(LockManagerImpl lockManager, final LockResource resource) {
        final RWLock[] locks = new RWLock[1];
        lockManager.accept((Visitor)new Visitor<RWLock, RuntimeException>(){

            public boolean visit(RWLock lock) throws RuntimeException {
                if (resource.equals(lock.resource())) {
                    locks[0] = lock;
                }
                return false;
            }
        });
        return locks[0];
    }

    private int countLocks(LockManagerImpl lockManager) {
        final int[] counter = new int[1];
        lockManager.accept((Visitor)new Visitor<RWLock, RuntimeException>(){

            public boolean visit(RWLock element) throws RuntimeException {
                counter[0] = counter[0] + 1;
                return false;
            }
        });
        return counter[0];
    }

    private class MockedLockLockManager
    extends LockManagerImpl {
        private RWLock lock;

        public MockedLockLockManager(RagManager ragManager, RWLock lock) {
            super(ragManager);
            this.lock = lock;
        }

        protected RWLock createLock(Object resource) {
            return this.lock;
        }
    }
}

