/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;

public class TestGrowingFileMemoryMapping {
    private static final int MEGA = 0x100000;
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldGrowAFileWhileContinuingToMemoryMapNewRegions() throws Exception {
        long startingId;
        Assume.assumeTrue((!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
        int NUMBER_OF_RECORDS = 1000000;
        File storeDir = this.testDirectory.graphDbDir();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), this.mmapSize(NUMBER_OF_RECORDS, 15)}), new Class[]{NodeStore.Configuration.class});
        DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)fileSystemAbstraction);
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fileSystemAbstraction, config);
        StoreFactory storeFactory = new StoreFactory(storeDir, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fileSystemAbstraction, (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = storeFactory.openAllNeoStores(true);
        NodeStore nodeStore = neoStores.getNodeStore();
        int iterations = 2 * NUMBER_OF_RECORDS;
        long nodeId = startingId = nodeStore.nextId();
        for (int i = 0; i < iterations; ++i) {
            NodeRecord record = new NodeRecord(nodeId, false, (long)i, 0L);
            record.setInUse(true);
            nodeStore.updateRecord(record);
            nodeId = nodeStore.nextId();
        }
        NodeRecord record = new NodeRecord(0L, false, 0L, 0L);
        for (int i = 0; i < iterations; ++i) {
            record.setId(startingId + (long)i);
            nodeStore.getRecord((long)i, (AbstractBaseRecord)record, RecordLoad.NORMAL);
            Assert.assertTrue((String)("record[" + i + "] should be in use"), (boolean)record.inUse());
            Assert.assertThat((String)("record[" + i + "] should have nextRelId of " + i), (Object)record.getNextRel(), (Matcher)Matchers.is((Object)i));
        }
        neoStores.close();
    }

    private String mmapSize(int numberOfRecords, int recordSize) {
        int bytes = numberOfRecords * recordSize;
        if (bytes < 0x100000) {
            throw new IllegalArgumentException("too few records: " + numberOfRecords);
        }
        return bytes / 0x100000 + "M";
    }
}

