/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.id.FreeIdKeeper;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class FreeIdKeeperTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void newlyConstructedInstanceShouldReportProperDefaultValues() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        Assert.assertEquals((long)-1L, (long)keeper.getId());
        Assert.assertEquals((long)0L, (long)keeper.getCount());
    }

    @Test
    public void freeingAnIdShouldReturnThatIdAndUpdateTheCountWhenAggressiveReuseIsSet() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        keeper.freeId(13L);
        Assert.assertEquals((long)1L, (long)keeper.getCount());
        long result = keeper.getId();
        Assert.assertEquals((long)13L, (long)result);
        Assert.assertEquals((long)0L, (long)keeper.getCount());
    }

    @Test
    public void shouldReturnMinusOneWhenRunningOutOfIds() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        keeper.freeId(13L);
        Assert.assertEquals((long)13L, (long)keeper.getId());
        Assert.assertEquals((long)-1L, (long)keeper.getId());
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldOnlyOverflowWhenThresholdIsReached() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.spy((Object)this.fs.open(new File("id.file"), "rw"));
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        Mockito.reset((Object[])new StoreChannel[]{channel});
        for (int i = 0; i < threshold - 1; ++i) {
            keeper.freeId((long)i);
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{channel});
        keeper.freeId(10L);
        ((StoreChannel)Mockito.verify((Object)channel)).write((ByteBuffer)Matchers.any(ByteBuffer.class));
    }

    @Test
    public void shouldReadBackPersistedIdsWhenAggressiveReuseIsSet() throws Exception {
        int i;
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        for (i = 0; i < threshold; ++i) {
            keeper.freeId((long)i);
        }
        for (i = 0; i < threshold; ++i) {
            Assert.assertEquals((long)i, (long)keeper.getId());
        }
    }

    @Test
    public void shouldReadBackManyPersistedIdBatchesWhenAggressiveReuseIsSet() throws Exception {
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i = 0L; i < (long)(threshold * 2); ++i) {
            keeper.freeId(i);
            freeIds.add(i);
        }
        Assert.assertEquals((long)freeIds.size(), (long)keeper.getCount());
        for (int i = threshold * 2 - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)freeIds.remove(keeper.getId()));
        }
    }

    @Test
    public void shouldFirstReturnNonPersistedIdsAndThenPersistedOnesWhenAggressiveReuse() throws Exception {
        int i;
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        for (int i2 = 0; i2 < threshold; ++i2) {
            keeper.freeId((long)i2);
        }
        int extraIds = 3;
        for (i = threshold; i < threshold + extraIds; ++i) {
            keeper.freeId((long)i);
        }
        for (i = threshold; i < threshold + extraIds; ++i) {
            Assert.assertEquals((long)i, (long)keeper.getId());
        }
        for (i = 0; i < threshold; ++i) {
            Assert.assertEquals((long)i, (long)keeper.getId());
        }
    }

    @Test
    public void persistedIdsShouldStillBeCounted() throws Exception {
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        for (int i = 0; i < threshold; ++i) {
            keeper.freeId((long)i);
        }
        int extraIds = 3;
        for (int i = threshold; i < threshold + extraIds; ++i) {
            keeper.freeId((long)i);
        }
        Assert.assertEquals((long)(threshold + extraIds), (long)keeper.getCount());
    }

    @Test
    public void shouldStoreAndRestoreIds() throws Exception {
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, true);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i = 0L; i < (long)threshold; ++i) {
            keeper.freeId(i);
            freeIds.add(i);
        }
        int extraIds = 3;
        for (long i = (long)threshold; i < (long)(threshold + extraIds); ++i) {
            keeper.freeId(i);
            freeIds.add(i);
        }
        keeper.close();
        channel.close();
        channel = this.fs.open(new File("id.file"), "rw");
        keeper = new FreeIdKeeper(channel, threshold, true);
        Assert.assertEquals((long)(threshold + extraIds), (long)keeper.getCount());
        Assert.assertEquals((long)freeIds.size(), (long)keeper.getCount());
        for (int i = threshold + extraIds - 1; i >= 0; --i) {
            long id = keeper.getId();
            Assert.assertTrue((boolean)freeIds.contains(id));
        }
    }

    @Test
    public void shouldNotReturnNewlyReleasedIdsIfAggressiveIsFalse() throws Exception {
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, false);
        keeper.freeId(1L);
        long nextFree = keeper.getId();
        Assert.assertEquals((long)-1L, (long)nextFree);
    }

    @Test
    public void shouldNotReturnIdsPersistedDuringThisRunIfAggressiveIsFalse() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.spy((Object)this.fs.open(new File("id.file"), "rw"));
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, false);
        for (int i = 0; i < threshold; ++i) {
            keeper.freeId((long)i);
        }
        ((StoreChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)Matchers.any(ByteBuffer.class));
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldReturnIdsRestoredAndIgnoreNewlyReleasedIfAggressiveReuseIsFalse() throws Exception {
        int i;
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, false);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i2 = 0L; i2 < (long)threshold; ++i2) {
            keeper.freeId(i2);
            freeIds.add(i2);
        }
        keeper.close();
        channel.close();
        channel = this.fs.open(new File("id.file"), "rw");
        keeper = new FreeIdKeeper(channel, threshold, false);
        for (i = 0; i < threshold; ++i) {
            keeper.freeId((long)i);
        }
        for (i = 0; i < threshold; ++i) {
            Assert.assertTrue((boolean)freeIds.remove(keeper.getId()));
        }
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldReturnNoResultIfIdsAreRestoredAndExhaustedAndThereAreFreeIdsFromThisRunWithAggressiveFalse() throws Exception {
        int i;
        StoreChannel channel = this.fs.open(new File("id.file"), "rw");
        int threshold = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, threshold, false);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i2 = 0L; i2 < (long)threshold; ++i2) {
            keeper.freeId(i2);
            freeIds.add(i2);
        }
        keeper.close();
        channel.close();
        channel = this.fs.open(new File("id.file"), "rw");
        keeper = new FreeIdKeeper(channel, threshold, false);
        for (i = 0; i < threshold; ++i) {
            Assert.assertTrue((boolean)freeIds.remove(keeper.getId()));
        }
        for (i = 0; i < threshold; ++i) {
            keeper.freeId((long)i);
        }
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }
}

