/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexConsultedPropertyBlockSweeper;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookupTest;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicatorTestUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class IndexConsultedPropertyBlockSweeperTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(IndexLookupTest.class);
    private GraphDatabaseAPI api;
    private long nodeId;
    private NodeStore nodeStore;
    private PropertyStore propertyStore;
    private Map<String, Integer> propertyKeys;
    private String nonIndexedPropKey;
    private String indexedPropKey;
    private IndexConsultedPropertyBlockSweeper sweeper;
    private IndexLookup.Index indexMock;
    private DuplicatePropertyRemover propertyRemoverMock;
    private String indexedValue;
    private String nonIndexedValue;
    private long propertyId;
    private NodeRecord nodeRecord;

    @Before
    public void setUp() throws IOException {
        this.api = this.dbRule.getGraphDatabaseAPI();
        this.nonIndexedPropKey = "notIndexed";
        this.indexedPropKey = "indexed";
        Label usedLabel = Label.label((String)"UsedLabel");
        try (Transaction transaction = this.api.beginTx();){
            this.api.schema().indexFor(usedLabel).on(this.indexedPropKey).create();
            transaction.success();
        }
        transaction = this.api.beginTx();
        var3_3 = null;
        try {
            this.indexedValue = "value1";
            this.nonIndexedValue = "value2";
            Node nodeA = this.api.createNode(new Label[]{usedLabel});
            nodeA.setProperty(this.indexedPropKey, (Object)this.indexedValue);
            nodeA.setProperty(this.nonIndexedPropKey, (Object)this.nonIndexedValue);
            this.nodeId = nodeA.getId();
            transaction.success();
        }
        catch (Throwable nodeA) {
            var3_3 = nodeA;
            throw nodeA;
        }
        finally {
            if (transaction != null) {
                if (var3_3 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable nodeA) {
                        var3_3.addSuppressed(nodeA);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        DependencyResolver resolver = this.api.getDependencyResolver();
        NeoStores neoStores = ((RecordStorageEngine)resolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.nodeStore = neoStores.getNodeStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        this.propertyKeys = PropertyDeduplicatorTestUtil.indexPropertyKeys(propertyKeyTokenStore);
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeRecord = (NodeRecord)RecordStore.getRecord((RecordStore)this.nodeStore, (long)this.nodeId);
        this.propertyId = this.nodeRecord.getNextProp();
        this.indexMock = (IndexLookup.Index)Mockito.mock(IndexLookup.Index.class);
        Mockito.when((Object)this.indexMock.contains(this.nodeId, (Object)this.indexedValue)).thenReturn((Object)true);
        this.propertyRemoverMock = (DuplicatePropertyRemover)Mockito.mock(DuplicatePropertyRemover.class);
    }

    @Test
    public void shouldNotRemoveIndexedValue() throws Exception {
        int propertyKeyId = this.propertyKeys.get(this.indexedPropKey);
        this.sweeper = new IndexConsultedPropertyBlockSweeper(propertyKeyId, this.indexMock, this.nodeRecord, this.propertyStore, this.propertyRemoverMock);
        Assert.assertFalse((boolean)this.sweeper.visited(this.propertyId));
        PropertyRecord propertyRecord = (PropertyRecord)RecordStore.getRecord((RecordStore)this.propertyStore, (long)this.propertyId);
        Assert.assertNotNull((Object)propertyRecord.getPropertyBlock(propertyKeyId));
    }

    @Test
    public void shouldRemoveNonIndexedValue() throws Exception {
        int propertyKeyId = this.propertyKeys.get(this.nonIndexedPropKey);
        this.sweeper = new IndexConsultedPropertyBlockSweeper(propertyKeyId, this.indexMock, this.nodeRecord, this.propertyStore, this.propertyRemoverMock);
        Assert.assertFalse((boolean)this.sweeper.visited(this.propertyId));
        PropertyRecord propertyRecord = (PropertyRecord)RecordStore.getRecord((RecordStore)this.propertyStore, (long)this.propertyId);
        Assert.assertNull((Object)propertyRecord.getPropertyBlock(propertyKeyId));
    }

    @Test
    public void shouldFixThePropertyChainAfterAllTheBlocksInRecordAreRemoved() throws IOException {
        int propertyKeyId = this.propertyKeys.get(this.indexedPropKey);
        PropertyRecord propertyRecord = (PropertyRecord)RecordStore.getRecord((RecordStore)this.propertyStore, (long)this.propertyId);
        for (PropertyBlock propertyBlock : propertyRecord) {
            long[] valueBlocks = propertyBlock.getValueBlocks();
            valueBlocks[1] = valueBlocks[1] + 2L;
            propertyBlock.setKeyIndexId(propertyKeyId);
        }
        this.propertyStore.updateRecord(propertyRecord);
        this.sweeper = new IndexConsultedPropertyBlockSweeper(propertyKeyId, this.indexMock, this.nodeRecord, this.propertyStore, this.propertyRemoverMock);
        Assert.assertFalse((boolean)this.sweeper.visited(this.propertyId));
        ((DuplicatePropertyRemover)Mockito.verify((Object)this.propertyRemoverMock)).fixUpPropertyLinksAroundUnusedRecord(this.nodeRecord, propertyRecord);
    }
}

