/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Readables;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.unsafe.impl.batchimport.input.DuplicateHeaderException;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class DataFactoriesTest {
    private static final int BUFFER_SIZE = 10000;
    private static final Configuration COMMAS = DataFactoriesTest.withBufferSize(Configuration.COMMAS, 10000);
    private static final Configuration TABS = DataFactoriesTest.withBufferSize(Configuration.TABS, 10000);
    private static final org.neo4j.csv.reader.Configuration SEEKER_CONFIG = new Configuration.Overridden((org.neo4j.csv.reader.Configuration)new Configuration.Default()){

        public int bufferSize() {
            return 1000;
        }
    };

    @Test
    public void shouldParseDefaultNodeFileHeaderCorrectly() throws Exception {
        CharSeeker seeker = this.seeker("ID:ID,label-one:label,also-labels:LABEL,name,age:long");
        IdType idType = IdType.STRING;
        Extractors extractors = new Extractors(',');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, COMMAS, idType);
        Assert.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("ID", Type.ID, idType.extractor(extractors)), this.entry("label-one", Type.LABEL, extractors.stringArray()), this.entry("also-labels", Type.LABEL, extractors.stringArray()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("age", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseDefaultRelationshipFileHeaderCorrectly() throws Exception {
        CharSeeker seeker = this.seeker(":START_ID\t:END_ID\ttype:TYPE\tdate:long\tmore:long[]");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatRelationshipFileHeader().create(seeker, TABS, idType);
        Assert.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry(null, Type.START_ID, idType.extractor(extractors)), this.entry(null, Type.END_ID, idType.extractor(extractors)), this.entry("type", Type.TYPE, extractors.string()), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_()), this.entry("more", Type.PROPERTY, extractors.longArray())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldHaveEmptyHeadersBeInterpretedAsIgnored() throws Exception {
        CharSeeker seeker = this.seeker("one:id\ttwo\t\tdate:long");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, idType);
        Assert.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("one", Type.ID, (Extractor<?>)extractors.long_()), this.entry("two", Type.PROPERTY, extractors.string()), this.entry(null, Type.IGNORE, null), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldFailForDuplicatePropertyHeaderEntries() throws Exception {
        CharSeeker seeker = this.seeker("one:id\tname\tname:long");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        try {
            DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, idType);
            Assert.fail((String)"Should fail");
        }
        catch (DuplicateHeaderException e) {
            Assert.assertEquals((Object)this.entry("name", Type.PROPERTY, extractors.string()), (Object)e.getFirst());
            Assert.assertEquals((Object)this.entry("name", Type.PROPERTY, (Extractor<?>)extractors.long_()), (Object)e.getOther());
        }
        seeker.close();
    }

    @Test
    public void shouldFailForDuplicateIdHeaderEntries() throws Exception {
        CharSeeker seeker = this.seeker("one:id\ttwo:id");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        try {
            DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, idType);
            Assert.fail((String)"Should fail");
        }
        catch (DuplicateHeaderException e) {
            Assert.assertEquals((Object)this.entry("one", Type.ID, (Extractor<?>)extractors.long_()), (Object)e.getFirst());
            Assert.assertEquals((Object)this.entry("two", Type.ID, (Extractor<?>)extractors.long_()), (Object)e.getOther());
        }
        seeker.close();
    }

    @Test
    public void shouldAllowMissingIdHeaderEntry() throws Exception {
        CharSeeker seeker = this.seeker("one\ttwo");
        Extractors extractors = new Extractors(';');
        Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, TABS, IdType.ACTUAL);
        Assert.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("one", Type.PROPERTY, extractors.string()), this.entry("two", Type.PROPERTY, extractors.string())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseHeaderFromFirstLineOfFirstInputFile() throws Exception {
        StringReader firstSource = new StringReader("id:ID\tname:String\tbirth_date:long");
        StringReader secondSource = new StringReader("0\tThe node\t123456789");
        DataFactory dataFactory = DataFactories.data(value -> value, () -> {
            try {
                return Readables.sources((Reader[])new Reader[]{firstSource, secondSource});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        Header.Factory headerFactory = DataFactories.defaultFormatNodeFileHeader();
        Extractors extractors = new Extractors(';');
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)dataFactory.create(TABS).stream(), (org.neo4j.csv.reader.Configuration)TABS, (boolean)false);
        Header header = headerFactory.create(seeker, TABS, IdType.ACTUAL);
        Assert.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry("id", Type.ID, (Extractor<?>)extractors.long_()), this.entry("name", Type.PROPERTY, extractors.string()), this.entry("birth_date", Type.PROPERTY, (Extractor<?>)extractors.long_())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldParseGroupName() throws Exception {
        CharSeeker seeker = this.seeker(":START_ID(GroupOne)\t:END_ID(GroupTwo)\ttype:TYPE\tdate:long\tmore:long[]");
        IdType idType = IdType.ACTUAL;
        Extractors extractors = new Extractors('\t');
        Header header = DataFactories.defaultFormatRelationshipFileHeader().create(seeker, TABS, idType);
        Assert.assertArrayEquals((Object[])ArrayUtil.array((Object[])new Header.Entry[]{this.entry(null, Type.START_ID, "GroupOne", idType.extractor(extractors)), this.entry(null, Type.END_ID, "GroupTwo", idType.extractor(extractors)), this.entry("type", Type.TYPE, extractors.string()), this.entry("date", Type.PROPERTY, (Extractor<?>)extractors.long_()), this.entry("more", Type.PROPERTY, extractors.longArray())}), (Object[])header.entries());
        seeker.close();
    }

    @Test
    public void shouldFailOnUnexpectedNodeHeaderType() throws Exception {
        CharSeeker seeker = this.seeker(":ID,:START_ID");
        IdType idType = IdType.ACTUAL;
        try {
            Header header = DataFactories.defaultFormatNodeFileHeader().create(seeker, COMMAS, idType);
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"START_ID"));
        }
    }

    @Test
    public void shouldFailOnUnexpectedRelationshipHeaderType() throws Exception {
        CharSeeker seeker = this.seeker(":LABEL,:START_ID,:END_ID,:TYPE");
        IdType idType = IdType.ACTUAL;
        try {
            Header header = DataFactories.defaultFormatRelationshipFileHeader().create(seeker, COMMAS, idType);
            Assert.fail((String)"Should have failed");
        }
        catch (InputException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"LABEL"));
        }
    }

    private CharSeeker seeker(String data) {
        return CharSeekers.charSeeker((CharReadable)Readables.wrap((Reader)new StringReader(data)), (org.neo4j.csv.reader.Configuration)SEEKER_CONFIG, (boolean)false);
    }

    private static Configuration withBufferSize(Configuration config, final int bufferSize) {
        return new Configuration.Overridden(config){

            public int bufferSize() {
                return bufferSize;
            }
        };
    }

    private Header.Entry entry(String name, Type type, Extractor<?> extractor) {
        return this.entry(name, type, null, extractor);
    }

    private Header.Entry entry(String name, Type type, String groupName, Extractor<?> extractor) {
        return new Header.Entry(name, type, groupName, extractor);
    }
}

