/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ForkedProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class CalculateDenseNodesStep
extends ForkedProcessorStep<Batch<InputRelationship, RelationshipRecord>> {
    private final NodeRelationshipCache cache;
    private final Collector badCollector;

    public CalculateDenseNodesStep(StageControl control, Configuration config, NodeRelationshipCache cache, Collector badCollector) {
        super(control, "CALCULATE", config, 0);
        this.cache = cache;
        this.badCollector = badCollector;
    }

    @Override
    protected void forkedProcess(int id, int processors, Batch<InputRelationship, RelationshipRecord> batch) {
        int idIndex = 0;
        for (int i = 0; i < ((InputRelationship[])batch.input).length; ++i) {
            InputRelationship relationship = ((InputRelationship[])batch.input)[i];
            long startNodeId = batch.ids[idIndex++];
            long endNodeId = batch.ids[idIndex++];
            this.processNodeId(id, processors, startNodeId, relationship, relationship.startNode());
            if (startNodeId == endNodeId && startNodeId != -1L) continue;
            this.processNodeId(id, processors, endNodeId, relationship, relationship.endNode());
        }
    }

    private void processNodeId(int id, int processors, long nodeId, InputRelationship relationship, Object inputId) {
        if (nodeId == -1L) {
            if (id == 0) {
                this.badCollector.collectBadRelationship(relationship, inputId);
            }
        } else if (nodeId % (long)processors == (long)id) {
            this.cache.incrementCount(nodeId);
        }
    }
}

