/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DummyExtension;
import org.neo4j.kernel.DummyExtensionFactory;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactoryContractTest;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public final class TestKernelExtension
extends KernelExtensionFactoryContractTest {
    public TestKernelExtension() {
        super("dummy", DummyExtensionFactory.class);
    }

    @Test
    public void shouldBeStarted() throws Exception {
        GraphDatabaseAPI graphdb = this.graphdb(0);
        try {
            Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)((DummyExtension)((KernelExtensions)graphdb.getDependencyResolver().resolveDependency(KernelExtensions.class)).resolveDependency(DummyExtension.class)).getStatus());
        }
        finally {
            graphdb.shutdown();
        }
    }

    @Test
    public void dependenciesCanBeRetrieved() throws Exception {
        GraphDatabaseAPI graphdb = this.graphdb(0);
        try {
            Assert.assertEquals((Object)graphdb.getDependencyResolver().resolveDependency(Config.class), (Object)((DummyExtension)((KernelExtensions)graphdb.getDependencyResolver().resolveDependency(KernelExtensions.class)).resolveDependency(DummyExtension.class)).getDependencies().getConfig());
            Assert.assertEquals((Object)graphdb.getDependencyResolver().resolveDependency(NeoStoreDataSource.class), (Object)((DummyExtension)((KernelExtensions)graphdb.getDependencyResolver().resolveDependency(KernelExtensions.class)).resolveDependency(DummyExtension.class)).getDependencies().getNeoStoreDataSource().get());
        }
        finally {
            graphdb.shutdown();
        }
    }

    @Test
    public void shouldBeShutdown() throws Exception {
        GraphDatabaseAPI graphdb = this.graphdb(0);
        graphdb.shutdown();
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)((DummyExtension)((KernelExtensions)graphdb.getDependencyResolver().resolveDependency(KernelExtensions.class)).resolveDependency(DummyExtension.class)).getStatus());
    }
}

