/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexSchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.builtinprocs.StubKernelTransaction;

public class AwaitIndexProcedureTest {
    private static final int timeout = 40;
    private static final TimeUnit timeoutUnits = TimeUnit.MILLISECONDS;
    private final ReadOperations operations = (ReadOperations)Mockito.mock(ReadOperations.class);
    private final IndexProcedures procedure = new IndexProcedures((KernelTransaction)new StubKernelTransaction(this.operations), null);

    @Test
    public void shouldThrowAnExceptionIfTheLabelDoesntExist() throws ProcedureException {
        Mockito.when((Object)this.operations.labelGetForName("NonExistentLabel")).thenReturn((Object)-1);
        try {
            this.procedure.awaitIndex(":NonExistentLabel(prop)", 40L, timeoutUnits);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.LabelAccessFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfThePropertyKeyDoesntExist() throws ProcedureException {
        Mockito.when((Object)this.operations.propertyKeyGetForName("nonExistentProperty")).thenReturn((Object)-1);
        try {
            this.procedure.awaitIndex(":Label(nonExistentProperty)", 40L, timeoutUnits);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.PropertyKeyAccessFailed));
        }
    }

    @Test
    public void shouldLookUpTheIndexByLabelIdAndPropertyKeyId() throws ProcedureException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)123);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)456);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)new IndexDescriptor(0, 0));
        Mockito.when((Object)this.operations.indexGetState((IndexDescriptor)org.mockito.Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.ONLINE);
        this.procedure.awaitIndex(":Person(name)", 40L, timeoutUnits);
        ((ReadOperations)Mockito.verify((Object)this.operations)).indexGetForLabelAndPropertyKey(123, 456);
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexHasFailed() throws SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)new IndexDescriptor(0, 0));
        Mockito.when((Object)this.operations.indexGetState((IndexDescriptor)org.mockito.Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.FAILED);
        try {
            this.procedure.awaitIndex(":Person(name)", 40L, timeoutUnits);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.IndexCreationFailed));
        }
    }

    @Test
    public void shouldThrowAnExceptionIfTheIndexDoesNotExist() throws SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenThrow(new Throwable[]{new IndexSchemaRuleNotFoundException(-1, -1)});
        try {
            this.procedure.awaitIndex(":Person(name)", 40L, timeoutUnits);
            Assert.fail((String)"Expected an exception");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.status(), (Matcher)Matchers.is((Object)Status.Schema.IndexNotFound));
        }
    }

    @Test
    public void shouldBlockUntilTheIndexIsOnline() throws SchemaRuleNotFoundException, IndexNotFoundKernelException, InterruptedException {
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)new IndexDescriptor(0, 0));
        final AtomicReference<InternalIndexState> state = new AtomicReference<InternalIndexState>(InternalIndexState.POPULATING);
        Mockito.when((Object)this.operations.indexGetState((IndexDescriptor)org.mockito.Matchers.any(IndexDescriptor.class))).then((Answer)new Answer<InternalIndexState>(){

            public InternalIndexState answer(InvocationOnMock invocationOnMock) throws Throwable {
                return (InternalIndexState)state.get();
            }
        });
        AtomicBoolean done = new AtomicBoolean(false);
        new Thread(() -> {
            try {
                this.procedure.awaitIndex(":Person(name)", 40L, timeoutUnits);
            }
            catch (ProcedureException e) {
                throw new RuntimeException(e);
            }
            done.set(true);
        }).start();
        Assert.assertThat((Object)done.get(), (Matcher)Matchers.is((Object)false));
        state.set(InternalIndexState.ONLINE);
        org.neo4j.test.assertion.Assert.assertEventually("Procedure did not return after index was online", done::get, Matchers.is((Object)true), 10L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldTimeoutIfTheIndexTakesTooLongToComeOnline() throws InterruptedException, SchemaRuleNotFoundException, IndexNotFoundKernelException {
        Mockito.when((Object)this.operations.labelGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.propertyKeyGetForName(org.mockito.Matchers.anyString())).thenReturn((Object)0);
        Mockito.when((Object)this.operations.indexGetForLabelAndPropertyKey(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)new IndexDescriptor(0, 0));
        Mockito.when((Object)this.operations.indexGetState((IndexDescriptor)org.mockito.Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.POPULATING);
        AtomicReference exception = new AtomicReference();
        new Thread(() -> {
            try {
                this.procedure.awaitIndex(":Person(name)", 40L, timeoutUnits);
            }
            catch (ProcedureException e) {
                exception.set(e);
            }
        }).start();
        org.neo4j.test.assertion.Assert.assertEventually("Procedure did not time out", exception::get, Matchers.not((Matcher)Matchers.nullValue()), 10L, TimeUnit.SECONDS);
        Assert.assertThat((Object)((ProcedureException)((Object)exception.get())).status(), (Matcher)Matchers.is((Object)Status.Procedure.ProcedureTimedOut));
    }
}

