/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.Settings;

public class GroupConfigTest {
    @Test
    public void shouldProvideNiceSetMechanism() throws Throwable {
        Assert.assertThat((Object)GroupConfigTest.connector((int)0).enabled.name(), (Matcher)CoreMatchers.equalTo((Object)"dbms.connector.0.enabled"));
    }

    @Test
    public void shouldProvideConvenientWayToEnumerateGroups() throws Throwable {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GroupConfigTest.connector((int)0).enabled.name(), "true", GroupConfigTest.connector((int)1).enabled.name(), "false", GroupConfigTest.connector((int)1).name.name(), "Cat Stevens", GroupConfigTest.connector((int)3).enabled.name(), "false"}));
        List groups = ((Stream)config.view(GroupSettingSupport.enumerate(ConnectorExample.class))).map(ConnectorExample::new).collect(Collectors.toList());
        Assert.assertThat((Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Assert.assertThat((Object)config.get(((ConnectorExample)groups.get((int)0)).enabled), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)config.get(((ConnectorExample)groups.get((int)0)).name), (Matcher)CoreMatchers.equalTo((Object)"Bob Dylan"));
        Assert.assertThat((Object)config.get(((ConnectorExample)groups.get((int)1)).enabled), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)config.get(((ConnectorExample)groups.get((int)1)).name), (Matcher)CoreMatchers.equalTo((Object)"Cat Stevens"));
        Assert.assertThat((Object)config.get(((ConnectorExample)groups.get((int)2)).enabled), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)config.get(((ConnectorExample)groups.get((int)2)).name), (Matcher)CoreMatchers.equalTo((Object)"Bob Dylan"));
    }

    static ConnectorExample connector(int key) {
        return new ConnectorExample(Integer.toString(key));
    }

    @Group(value="dbms.connector")
    static class ConnectorExample {
        public final Setting<Boolean> enabled;
        public final Setting<String> name;
        private final GroupSettingSupport group;

        public ConnectorExample(String key) {
            this.group = new GroupSettingSupport(ConnectorExample.class, key);
            this.enabled = this.group.scope(Settings.setting((String)"enabled", (Function)Settings.BOOLEAN, (String)"false"));
            this.name = this.group.scope(Settings.setting((String)"name", (Function)Settings.STRING, (String)"Bob Dylan"));
        }
    }
}

