/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.api.PropertyValueComparator;

public class PropertyValueComparatorTest {
    private final PropertyValueComparator<Integer> COMPARATOR = new PropertyValueComparator<Integer>(){

        public int compare(Integer x, Integer y) {
            return Integer.compare(x, y);
        }
    };
    private static final boolean DEBUG = false;
    private static final boolean[] BOOLEANS = new boolean[]{true, false};
    private static final int LOWER = 10;
    private static final int UPPER = 20;
    private static final int[] BOUND_VALUES = new int[]{10, 11, 12, 13, 14};
    private static final double[] TESTED_VALUES = new double[]{7.5, 8.5, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5, 12.0, 12.5, 13.0, 13.5, 14.0, 14.5, 15.0, 15.5, 16.0, 16.5};

    @Test
    public void shouldDetectEmptyRanges() {
        for (boolean includeLower : BOOLEANS) {
            for (boolean includeUpper : BOOLEANS) {
                for (int lower : BOUND_VALUES) {
                    for (int upper : BOUND_VALUES) {
                        if (this.COMPARATOR.isEmptyRange((Object)lower, includeLower, (Object)upper, includeUpper)) {
                            this.assertRangeExcludesAllValues(includeLower, lower, includeUpper, upper);
                        } else {
                            this.assertRangeIncludesSomeValue(includeLower, lower, includeUpper, upper);
                        }
                        PropertyValueComparatorTest.debug("\n");
                    }
                }
            }
        }
    }

    @Test
    public void shouldHandleNulls() {
        for (boolean includeLower : BOOLEANS) {
            for (boolean includeUpper : BOOLEANS) {
                Assert.assertFalse((boolean)this.COMPARATOR.isEmptyRange(null, includeLower, (Object)10, includeUpper));
                Assert.assertFalse((boolean)this.COMPARATOR.isEmptyRange((Object)10, includeLower, null, includeUpper));
                Assert.assertFalse((boolean)this.COMPARATOR.isEmptyRange(null, includeLower, null, includeUpper));
            }
        }
    }

    private void assertRangeExcludesAllValues(boolean includeLower, int lower, boolean includeUpper, int upper) {
        PropertyValueComparatorTest.debug(String.format("Checking empty range %d %s x %s %d (cmp: %d)... Excludes... ", lower, includeLower ? ">=" : ">", includeUpper ? "<=" : "<", upper, Integer.compare(lower, upper)));
        for (double value : TESTED_VALUES) {
            Assert.assertFalse((boolean)this.rangeIncludesGivenValue(includeLower, lower, includeUpper, upper, value));
        }
    }

    private void assertRangeIncludesSomeValue(boolean includeLower, int lower, boolean includeUpper, int upper) {
        PropertyValueComparatorTest.debug(String.format("Checking non-empty range %d %s x %s %d (cmp: %d)... Includes... ", lower, includeLower ? ">=" : ">", includeUpper ? "<=" : "<", upper, Integer.compare(lower, upper)));
        boolean includesAny = false;
        for (double value : TESTED_VALUES) {
            includesAny |= this.rangeIncludesGivenValue(includeLower, lower, includeUpper, upper, value);
        }
        Assert.assertTrue((boolean)includesAny);
    }

    private boolean rangeIncludesGivenValue(boolean includeLower, int lower, boolean includeUpper, int upper, double value) {
        boolean upperInRange;
        boolean lowerInRange;
        boolean bl = includeLower ? value >= (double)lower : (lowerInRange = value > (double)lower);
        boolean bl2 = includeUpper ? value <= (double)upper : (upperInRange = value < (double)upper);
        if (lowerInRange && upperInRange) {
            PropertyValueComparatorTest.debug(String.format("%s ", value));
            return true;
        }
        return false;
    }

    private static void debug(String text) {
    }
}

