/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Comparator;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.api.PropertyValueComparison;

public class PropertyValueComparisonTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    Object[] values = new Object[]{PropertyValueComparison.LOWEST_OBJECT, new Object(), "", Character.valueOf('\u0000'), " ", "20", "x", "y", Character.valueOf('\ud800'), Character.valueOf('\udbff'), Character.valueOf('\udc00'), Character.valueOf('\udfff'), Character.valueOf('\uffff'), false, true, Double.NEGATIVE_INFINITY, -1.7976931348623157E308, Long.MIN_VALUE, -9223372036854775807L, Integer.MIN_VALUE, (short)Short.MIN_VALUE, (byte)-128, 0, Double.MIN_VALUE, Double.MIN_NORMAL, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MIN_NORMAL), 1L, 1.1, Float.valueOf(1.2f), Math.E, Math.PI, (byte)10, (short)20, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, 9.007199254740992E15, 0x20000000000001L, Long.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN};

    @Test
    public void valueComparatorShouldRejectLeftNullArgument() {
        this.thrown.expect(NullPointerException.class);
        PropertyValueComparison.COMPARE_VALUES.compare(null, (Object)1);
    }

    @Test
    public void valueComparatorShouldRejectRightNullArgument() {
        this.thrown.expect(NullPointerException.class);
        PropertyValueComparison.COMPARE_VALUES.compare((Object)1, null);
    }

    @Test
    public void numberComparatorShouldRejectLeftNullArgument() {
        this.thrown.expect(NullPointerException.class);
        PropertyValueComparison.COMPARE_NUMBERS.compare(null, (Object)1);
    }

    @Test
    public void numberComparatorShouldRejectRightNullArgument() {
        this.thrown.expect(NullPointerException.class);
        PropertyValueComparison.COMPARE_NUMBERS.compare((Object)1, null);
    }

    @Test
    public void stringComparatorShouldRejectLeftNullArgument() {
        this.thrown.expect(NullPointerException.class);
        PropertyValueComparison.COMPARE_STRINGS.compare(null, (Object)"foo");
    }

    @Test
    public void stringComparatorShouldRejectRightNullArgument() {
        this.thrown.expect(NullPointerException.class);
        PropertyValueComparison.COMPARE_STRINGS.compare((Object)"foo", null);
    }

    @Test
    public void shouldOrderValuesCorrectly() {
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values.length; ++j) {
                int cmpNum;
                int cmpVal;
                Object left = this.values[i];
                Object right = this.values[j];
                int cmpPos = this.sign(i - j);
                if (cmpPos != (cmpVal = this.sign(this.compare((Comparator)PropertyValueComparison.COMPARE_VALUES, (Object)left, (Object)right)))) {
                    throw new AssertionError((Object)String.format("Comparing %s against %s does not agree with their positions in the sorted list (%d and %d)", left, right, i, j));
                }
                if (PropertyValueComparison.SuperType.NUMBER.isSuperTypeOf(left) && PropertyValueComparison.SuperType.NUMBER.isSuperTypeOf(right) && cmpPos != (cmpNum = this.sign(this.compare((Comparator)PropertyValueComparison.COMPARE_NUMBERS, (Object)((Number)left), (Object)((Number)right))))) {
                    throw new AssertionError((Object)String.format("Comparing %s against %s numerically does not agree with their positions in the sorted list (%d and %d)", left, right, i, j));
                }
                if (PropertyValueComparison.SuperType.STRING.isSuperTypeOf(left) && PropertyValueComparison.SuperType.STRING.isSuperTypeOf(right) && cmpPos != (cmpNum = this.sign(this.compare((Comparator)PropertyValueComparison.COMPARE_STRINGS, (Object)left, (Object)right)))) {
                    throw new AssertionError((Object)String.format("Comparing %s against %s textually does not agree with their positions in the sorted list (%d and %d)", left, right, i, j));
                }
            }
        }
    }

    private <T> int compare(Comparator<T> comparator, T left, T right) {
        int cmp1 = comparator.compare(left, right);
        int cmp2 = comparator.compare(right, left);
        if (this.sign(cmp1) != -this.sign(cmp2)) {
            throw new AssertionError((Object)String.format("%s is not symmetric on %s and %s", comparator, left, right));
        }
        return cmp1;
    }

    private int sign(int value) {
        return value == 0 ? 0 : (value < 0 ? -1 : 1);
    }
}

