/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;

public class TransactionQueueTest {
    @Test
    public void shouldEmptyIfTooMany() throws Exception {
        int i;
        TransactionQueue.Applier applier = (TransactionQueue.Applier)Mockito.mock(TransactionQueue.Applier.class);
        int batchSize = 10;
        TransactionQueue queue = new TransactionQueue(batchSize, applier);
        for (i = 0; i < 9; ++i) {
            queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{applier});
        }
        queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
        ((TransactionQueue.Applier)Mockito.verify((Object)applier, (VerificationMode)Mockito.times((int)1))).apply((TransactionToApply)Matchers.any(), (TransactionToApply)Matchers.any());
        Mockito.reset((Object[])new TransactionQueue.Applier[]{applier});
        queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
        for (i = 0; i < 2; ++i) {
            queue.queue((TransactionToApply)Mockito.mock(TransactionToApply.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{applier});
        }
        queue.empty();
        ((TransactionQueue.Applier)Mockito.verify((Object)applier, (VerificationMode)Mockito.times((int)1))).apply((TransactionToApply)Matchers.any(), (TransactionToApply)Matchers.any());
    }

    @Test
    public void shouldLinkTogetherTransactions() throws Exception {
        int i;
        TransactionQueue.Applier applier = (TransactionQueue.Applier)Mockito.mock(TransactionQueue.Applier.class);
        int batchSize = 10;
        TransactionQueue queue = new TransactionQueue(batchSize, applier);
        TransactionToApply[] txs = new TransactionToApply[batchSize];
        for (i = 0; i < batchSize; ++i) {
            txs[i] = new TransactionToApply((TransactionRepresentation)Mockito.mock(TransactionRepresentation.class));
            queue.queue(txs[i]);
        }
        ((TransactionQueue.Applier)Mockito.verify((Object)applier, (VerificationMode)Mockito.times((int)1))).apply((TransactionToApply)Matchers.any(), (TransactionToApply)Matchers.any());
        for (i = 0; i < txs.length - 1; ++i) {
            Assert.assertEquals((Object)txs[i + 1], (Object)txs[i].next());
        }
    }
}

