/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.inmemory;

import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndex;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.api.index.inmemory.UniqueInMemoryIndex;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class InMemoryIndexProvider
extends SchemaIndexProvider {
    private final Map<Long, InMemoryIndex> indexes;

    public InMemoryIndexProvider() {
        this(0);
    }

    public InMemoryIndexProvider(int prio) {
        this(prio, (Map<Long, InMemoryIndex>)new CopyOnWriteHashMap());
    }

    private InMemoryIndexProvider(int prio, Map<Long, InMemoryIndex> indexes) {
        super(InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR, prio);
        this.indexes = indexes;
    }

    public InternalIndexState getInitialState(long indexId) {
        InMemoryIndex index = this.indexes.get(indexId);
        return index != null ? index.getState() : InternalIndexState.POPULATING;
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, LabelScanStoreProvider labelScanStoreProvider) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexConfiguration config, IndexSamplingConfig samplingConfig) {
        InMemoryIndex index = config.isUnique() ? new UniqueInMemoryIndex(descriptor.getPropertyKeyId()) : new InMemoryIndex();
        this.indexes.put(indexId, index);
        return index.getPopulator();
    }

    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexConfiguration indexConfig, IndexSamplingConfig samplingConfig) {
        InMemoryIndex index = this.indexes.get(indexId);
        if (index == null || index.getState() != InternalIndexState.ONLINE) {
            throw new IllegalStateException("Index " + indexId + " not online yet");
        }
        if (indexConfig.isUnique() && !(index instanceof UniqueInMemoryIndex)) {
            throw new IllegalStateException(String.format("The index [%s] was not created as a unique index.", indexId));
        }
        return index.getOnlineAccessor();
    }

    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String failure = this.indexes.get((Object)Long.valueOf((long)indexId)).failure;
        if (failure == null) {
            throw new IllegalStateException();
        }
        return failure;
    }

    public InMemoryIndexProvider snapshot() {
        CopyOnWriteHashMap copy = new CopyOnWriteHashMap();
        for (Map.Entry<Long, InMemoryIndex> entry : this.indexes.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().snapshot());
        }
        return new InMemoryIndexProvider(this.priority, (Map<Long, InMemoryIndex>)copy);
    }
}

