/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.SchemaCache;

public class CacheLayerTest {
    private final DiskLayer diskLayer = (DiskLayer)Mockito.mock(DiskLayer.class);
    private final SchemaCache schemaCache = (SchemaCache)Mockito.mock(SchemaCache.class);
    private final CacheLayer context = new CacheLayer(this.diskLayer, this.schemaCache);

    @Test
    public void shouldLoadAllConstraintsFromCache() throws Exception {
        Set constraints = Iterators.asSet((Object[])new PropertyConstraint[]{new UniquenessConstraint(0, 1)});
        Mockito.when((Object)this.schemaCache.constraints()).thenReturn(constraints.iterator());
        Assert.assertThat((Object)Iterators.asSet((Iterator)this.context.constraintsGetAll()), (Matcher)Matchers.equalTo((Object)constraints));
    }

    @Test
    public void shouldLoadConstraintsByLabelFromCache() throws Exception {
        int labelId = 0;
        Set constraints = Iterators.asSet((Object[])new NodePropertyConstraint[]{new UniquenessConstraint(labelId, 1)});
        Mockito.when((Object)this.schemaCache.constraintsForLabel(labelId)).thenReturn(constraints.iterator());
        Assert.assertThat((Object)Iterators.asSet((Iterator)this.context.constraintsGetForLabel(labelId)), (Matcher)Matchers.equalTo((Object)constraints));
    }

    @Test
    public void shouldLoadConstraintsByLabelAndPropertyFromCache() throws Exception {
        int labelId = 0;
        int propertyId = 1;
        Set constraints = Iterators.asSet((Object[])new NodePropertyConstraint[]{new UniquenessConstraint(labelId, propertyId)});
        Mockito.when((Object)this.schemaCache.constraintsForLabelAndProperty(labelId, propertyId)).thenReturn(constraints.iterator());
        Assert.assertThat((Object)Iterators.asSet((Iterator)this.context.constraintsGetForLabelAndPropertyKey(labelId, propertyId)), (Matcher)Matchers.equalTo((Object)constraints));
    }
}

