/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.GraphTransactionRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class TestShortStringProperties {
    @ClassRule
    public static DatabaseRule graphdb = new ImpermanentDatabaseRule();
    @Rule
    public GraphTransactionRule tx = new GraphTransactionRule(graphdb);
    private static final String LONG_STRING = "this is a really long string, believe me!";

    public void commit() {
        this.tx.success();
    }

    private void newTx() {
        this.tx.success();
        this.tx.begin();
    }

    @Test
    public void canAddMultipleShortStringsToTheSameNode() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)"value");
        node.setProperty("reverse", (Object)"esrever");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), Neo4jMatchers.hasProperty("key").withValue("value")));
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), Neo4jMatchers.hasProperty("reverse").withValue("esrever")));
    }

    @Test
    public void canAddShortStringToRelationship() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        GraphDatabaseAPI db = graphdb.getGraphDatabaseAPI();
        Relationship rel = db.createNode().createRelationshipTo(db.createNode(), RelationshipType.withName((String)"REL_TYPE"));
        rel.setProperty("type", (Object)"dimsedut");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertThat((Object)rel, Neo4jMatchers.inTx((GraphDatabaseService)db, Neo4jMatchers.hasProperty("type").withValue("dimsedut")));
    }

    @Test
    public void canUpdateShortStringInplace() throws Exception {
        try {
            long recordCount = this.dynamicRecordsInUse();
            long propCount = this.propertyRecordsInUse();
            Node node = graphdb.getGraphDatabaseAPI().createNode();
            node.setProperty("key", (Object)"value");
            this.newTx();
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
            Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
            Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
            node.setProperty("key", (Object)"other");
            this.commit();
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
            Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
            Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), Neo4jMatchers.hasProperty("key").withValue("other")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void canReplaceLongStringWithShortString() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)LONG_STRING);
        this.newTx();
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)LONG_STRING, (Object)node.getProperty("key"));
        node.setProperty("key", (Object)"value");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), Neo4jMatchers.hasProperty("key").withValue("value")));
    }

    @Test
    public void canReplaceShortStringWithLongString() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.setProperty("key", (Object)LONG_STRING);
        this.commit();
        Assert.assertEquals((long)(recordCount + 1L), (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)graphdb.getGraphDatabaseAPI(), Neo4jMatchers.hasProperty("key").withValue(LONG_STRING)));
    }

    @Test
    public void canRemoveShortStringProperty() throws Exception {
        long recordCount = this.dynamicRecordsInUse();
        long propCount = this.propertyRecordsInUse();
        GraphDatabaseAPI db = graphdb.getGraphDatabaseAPI();
        Node node = db.createNode();
        node.setProperty("key", (Object)"value");
        this.newTx();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)(propCount + 1L), (long)this.propertyRecordsInUse());
        Assert.assertEquals((Object)"value", (Object)node.getProperty("key"));
        node.removeProperty("key");
        this.commit();
        Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        Assert.assertEquals((long)propCount, (long)this.propertyRecordsInUse());
        Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)db, Matchers.not((Matcher)Neo4jMatchers.hasProperty("key"))));
    }

    @Test
    public void canEncodeEmptyString() throws Exception {
        this.assertCanEncode("");
    }

    @Test
    public void canEncodeReallyLongString() throws Exception {
        this.assertCanEncode("                    ");
        this.assertCanEncode("                ");
    }

    @Test
    public void canEncodeFifteenSpaces() throws Exception {
        this.assertCanEncode("               ");
    }

    @Test
    public void canEncodeNumericalString() throws Exception {
        this.assertCanEncode("0123456789+,'.-");
        this.assertCanEncode(" ,'.-0123456789");
        this.assertCanEncode("+ '.0123456789-");
        this.assertCanEncode("+, 0123456789.-");
        this.assertCanEncode("+,0123456789' -");
        this.assertCanEncode("+0123456789,'. ");
        this.assertCanEncode("192.168.0.1");
        this.assertCanEncode("127.0.0.1");
        this.assertCanEncode("255.255.255.255");
    }

    @Test
    public void canEncodeTooLongStringsWithCharsInDifferentTables() throws Exception {
        this.assertCanEncode("____________+");
        this.assertCanEncode("_____+_____");
        this.assertCanEncode("____+____");
        this.assertCanEncode("HELLO world");
        this.assertCanEncode("Hello_World");
    }

    @Test
    public void canEncodeUpToNineEuropeanChars() throws Exception {
        this.assertCanEncode("f\u00e5gel");
        this.assertCanEncode("p\u00e5f\u00e5gel");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6n");
        this.assertCanEncode("p\u00e5f\u00e5gel\u00f6ar");
    }

    @Test
    public void canEncodeEuropeanCharsWithPunctuation() throws Exception {
        this.assertCanEncode("qHm7 pp3");
        this.assertCanEncode("UKKY3t.gk");
    }

    @Test
    public void canEncodeAlphanumerical() throws Exception {
        this.assertCanEncode("1234567890");
        this.assertCanEncodeInBothCasings("HelloWor1d");
        this.assertCanEncode("          ");
        this.assertCanEncode("_ _ _ _ _ ");
        this.assertCanEncode("H3Lo_ or1D");
        this.assertCanEncode("q1w2e3r4t+");
    }

    @Test
    public void canEncodeHighUnicode() throws Exception {
        this.assertCanEncode("\u02ff");
        this.assertCanEncode("hello\u02ff");
    }

    @Test
    public void canEncodeLatin1SpecialChars() throws Exception {
        this.assertCanEncode("#$#$#$#");
        this.assertCanEncode("$hello#");
    }

    @Test
    public void canEncodeTooLongLatin1String() throws Exception {
        this.assertCanEncode("#$#$#$#$");
    }

    @Test
    public void canEncodeLowercaseAndUppercaseStringsUpTo12Chars() throws Exception {
        this.assertCanEncodeInBothCasings("hello world");
        this.assertCanEncode("hello_world");
        this.assertCanEncode("_hello_world");
        this.assertCanEncode("hello::world");
        this.assertCanEncode("hello//world");
        this.assertCanEncode("hello world");
        this.assertCanEncode("http://ok");
        this.assertCanEncode("::::::::");
        this.assertCanEncode(" _.-:/ _.-:/");
    }

    private void assertCanEncodeInBothCasings(String string) {
        this.assertCanEncode(string.toLowerCase());
        this.assertCanEncode(string.toUpperCase());
    }

    private void assertCanEncode(String string) {
        this.encode(string, true);
    }

    private void encode(String string, boolean isShort) {
        long recordCount = this.dynamicRecordsInUse();
        Node node = graphdb.getGraphDatabaseAPI().createNode();
        node.setProperty("key", (Object)string);
        this.newTx();
        if (isShort) {
            Assert.assertEquals((long)recordCount, (long)this.dynamicRecordsInUse());
        } else {
            Assert.assertTrue((recordCount < this.dynamicRecordsInUse() ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)string, (Object)node.getProperty("key"));
    }

    private long propertyRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore());
    }

    private long dynamicRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getStringStore());
    }

    private PropertyStore propertyStore() {
        return ((RecordStorageEngine)graphdb.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getPropertyStore();
    }
}

