/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.test.rule.concurrent.ThreadRepository;

public class ReentrantLockServiceTest {
    @Rule
    public final ThreadRepository threads = new ThreadRepository(5L, TimeUnit.SECONDS);

    @Test
    public void shouldFormLinkedListOfWaitingLockOwners() throws Exception {
        ReentrantLockService.OwnerQueueElement queue = new ReentrantLockService.OwnerQueueElement((Object)0);
        ReentrantLockService.OwnerQueueElement element1 = new ReentrantLockService.OwnerQueueElement((Object)1);
        ReentrantLockService.OwnerQueueElement element2 = new ReentrantLockService.OwnerQueueElement((Object)2);
        ReentrantLockService.OwnerQueueElement element3 = new ReentrantLockService.OwnerQueueElement((Object)3);
        ReentrantLockService.OwnerQueueElement element4 = new ReentrantLockService.OwnerQueueElement((Object)4);
        queue.enqueue(element1);
        Assert.assertEquals((long)1L, (long)((Integer)queue.dequeue()).intValue());
        queue.enqueue(element2);
        queue.enqueue(element3);
        queue.enqueue(element4);
        Assert.assertEquals((long)2L, (long)((Integer)queue.dequeue()).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)queue.dequeue()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)queue.dequeue()).intValue());
        Assert.assertEquals((String)"should get the current element when dequeuing the current head", (long)4L, (long)((Integer)queue.dequeue()).intValue());
        Assert.assertEquals((String)"should get null when dequeuing from a dead list", null, (Object)queue.dequeue());
        Assert.assertEquals((String)"should get null continuously when dequeuing from a dead list", null, (Object)queue.dequeue());
    }

    @Test
    public void shouldAllowReEntrance() throws Exception {
        ReentrantLockService locks = new ReentrantLockService();
        ThreadRepository.Events events = this.threads.events();
        LockNode lock1once = new LockNode((LockService)locks, 1L);
        LockNode lock1again = new LockNode((LockService)locks, 1L);
        LockNode lock1inOtherThread = new LockNode((LockService)locks, 1L);
        ThreadRepository.Signal lockedOnce = this.threads.signal();
        ThreadRepository.Signal ready = this.threads.signal();
        this.threads.execute(lock1once, ready.await(), lockedOnce, lock1again, events.trigger("Double Locked"), lock1once.release, lock1again.release);
        this.threads.execute(ready, lockedOnce.await(), lock1inOtherThread, events.trigger("Other Thread"), lock1inOtherThread.release);
        events.assertInOrder("Double Locked", "Other Thread");
    }

    @Test
    public void shouldBlockOnLockedLock() throws Exception {
        ReentrantLockService locks = new ReentrantLockService();
        LockNode lockSameNode = new LockNode((LockService)locks, 17L);
        ThreadRepository.Events events = this.threads.events();
        ThreadRepository.Signal ready = this.threads.signal();
        try (Lock ignored = locks.acquireNodeLock(17L, LockService.LockType.WRITE_LOCK);){
            ThreadRepository.ThreadInfo thread = this.threads.execute(ready, lockSameNode, events.trigger("locked"), lockSameNode.release);
            ready.awaitNow();
            Assert.assertTrue((boolean)ReentrantLockServiceTest.awaitParked(thread, 5L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)events.snapshot().isEmpty());
        }
        events.assertInOrder("locked");
    }

    @Test
    public void shouldNotLeaveResidualLockStateAfterAllLocksHaveBeenReleased() throws Exception {
        ReentrantLockService locks = new ReentrantLockService();
        locks.acquireNodeLock(42L, LockService.LockType.WRITE_LOCK).release();
        Assert.assertEquals((long)0L, (long)locks.lockCount());
    }

    @Test
    public void shouldPresentLockStateInStringRepresentationOfLock() throws Exception {
        Lock second;
        Lock first;
        ReentrantLockService locks = new ReentrantLockService();
        try (Lock lock = first = locks.acquireNodeLock(666L, LockService.LockType.WRITE_LOCK);){
            Assert.assertEquals((Object)("LockedNode[id=666; HELD_BY=1*" + Thread.currentThread() + "]"), (Object)lock.toString());
            try (Lock inner = second = locks.acquireNodeLock(666L, LockService.LockType.WRITE_LOCK);){
                Assert.assertEquals((Object)("LockedNode[id=666; HELD_BY=2*" + Thread.currentThread() + "]"), (Object)lock.toString());
                Assert.assertEquals((Object)lock.toString(), (Object)inner.toString());
            }
            Assert.assertEquals((Object)("LockedNode[id=666; HELD_BY=1*" + Thread.currentThread() + "]"), (Object)lock.toString());
            Assert.assertEquals((Object)"LockedNode[id=666; RELEASED]", (Object)second.toString());
        }
        Assert.assertEquals((Object)"LockedNode[id=666; RELEASED]", (Object)first.toString());
        Assert.assertEquals((Object)"LockedNode[id=666; RELEASED]", (Object)second.toString());
    }

    private static boolean awaitParked(ThreadRepository.ThreadInfo thread, long timeout, TimeUnit unit) {
        boolean parked = false;
        long end = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < end) {
            StackTraceElement frame = thread.getStackTrace()[0];
            if (!"park".equals(frame.getMethodName()) || !"sun.misc.Unsafe".equals(frame.getClassName()) || !thread.getState().name().endsWith("WAITING")) continue;
            parked = true;
            break;
        }
        return parked;
    }

    private static class LockNode
    implements ThreadRepository.Task {
        private final LockService locks;
        private final long nodeId;
        private Lock lock;
        private final ThreadRepository.Task release = new ThreadRepository.Task(){

            @Override
            public void perform() throws Exception {
                lock.release();
            }
        };

        LockNode(LockService locks, long nodeId) {
            this.locks = locks;
            this.nodeId = nodeId;
        }

        @Override
        public void perform() throws Exception {
            this.lock = this.locks.acquireNodeLock(this.nodeId, LockService.LockType.WRITE_LOCK);
        }
    }
}

