/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.OutputStream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;

public final class TestConfiguringPageCacheFactory
extends ConfiguringPageCacheFactory {
    private int configuredPageSize;

    private TestConfiguringPageCacheFactory(FileSystemAbstraction fs, Config config, PageCacheTracer tracer, Log log) {
        super(fs, config, tracer, log);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, PageCacheTracer tracer, int pageSize, Config config) {
        Config baseConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8M"}));
        Config finalConfig = baseConfig.with(config.getParams(), new Class[0]);
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.err);
        TestConfiguringPageCacheFactory pageCacheFactory = new TestConfiguringPageCacheFactory(fileSystem, finalConfig, tracer, logProvider.getLog(PageCache.class));
        pageCacheFactory.configuredPageSize = pageSize;
        return pageCacheFactory.getOrCreatePageCache();
    }

    public int calculatePageSize(Config config, PageSwapperFactory swapperFactory) {
        if (this.configuredPageSize != 0) {
            return this.configuredPageSize;
        }
        return super.calculatePageSize(config, swapperFactory);
    }
}

