/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.defaultanswers.ReturnsDeepStubs;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContext;

public class Neo4jTransactionalContextTest {
    private GraphDatabaseQueryService queryService;
    private Guard guard;
    private KernelStatement initialStatement;

    @Before
    public void setUp() {
        this.setUpMocks();
    }

    @Test
    public void checkKernelStatementOnCheck() throws Exception {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        Neo4jTransactionalContext transactionalContext = new Neo4jTransactionalContext(null, null, this.guard, null, null, initialTransaction, (Statement)this.initialStatement, null);
        transactionalContext.check();
        ((Guard)Mockito.verify((Object)this.guard)).check(this.initialStatement);
    }

    @Test
    public void neverStopsExecutingQueryDuringCommitAndRestartTx() {
        KernelTransaction initialKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        Mockito.when((Object)initialTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)initialTransaction.securityContext()).thenReturn((Object)securityContext);
        QueryRegistryOperations initialQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        PropertyContainerLocker locker = null;
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        KernelTransaction secondKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction secondTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Statement secondStatement = (Statement)Mockito.mock(Statement.class);
        QueryRegistryOperations secondQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)this.queryService.beginTransaction(transactionType, securityContext)).thenReturn((Object)secondTransaction);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{secondKTX});
        Mockito.when((Object)txBridge.get()).thenReturn((Object)secondStatement);
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(this.queryService, null, this.guard, txBridge, locker, initialTransaction, (Statement)this.initialStatement, executingQuery);
        context.commitAndRestartTx();
        Object[] mocks = new Object[]{txBridge, initialTransaction, initialQueryRegistry, initialKTX, secondQueryRegistry, secondKTX};
        InOrder order = Mockito.inOrder((Object[])mocks);
        ((InternalTransaction)order.verify((Object)initialTransaction)).transactionType();
        ((InternalTransaction)order.verify((Object)initialTransaction)).securityContext();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).get();
        ((QueryRegistryOperations)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(initialKTX);
        ((QueryRegistryOperations)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
        ((InternalTransaction)order.verify((Object)initialTransaction)).success();
        ((InternalTransaction)order.verify((Object)initialTransaction)).close();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
        ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(secondKTX);
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    @Test
    public void rollsBackNewlyCreatedTransactionIfTerminationDetectedOnCloseDuringPeriodicCommit() {
        InternalTransaction initialTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)new ReturnsDeepStubs());
        KernelTransaction.Type transactionType = KernelTransaction.Type.implicit;
        SecurityContext securityContext = SecurityContext.AUTH_DISABLED;
        Mockito.when((Object)initialTransaction.transactionType()).thenReturn((Object)transactionType);
        Mockito.when((Object)initialTransaction.securityContext()).thenReturn((Object)securityContext);
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        KernelTransaction initialKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Statement initialStatement = (Statement)Mockito.mock(Statement.class);
        QueryRegistryOperations initialQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        ExecutingQuery executingQuery = (ExecutingQuery)Mockito.mock(ExecutingQuery.class);
        PropertyContainerLocker locker = new PropertyContainerLocker();
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        KernelTransaction secondKTX = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        InternalTransaction secondTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        Statement secondStatement = (Statement)Mockito.mock(Statement.class);
        QueryRegistryOperations secondQueryRegistry = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)executingQuery.queryText()).thenReturn((Object)"X");
        Mockito.when((Object)executingQuery.queryParameters()).thenReturn(Collections.emptyMap());
        ((InternalTransaction)Mockito.doThrow(RuntimeException.class).when((Object)initialTransaction)).close();
        Mockito.when((Object)initialStatement.queryRegistration()).thenReturn((Object)initialQueryRegistry);
        Mockito.when((Object)queryService.beginTransaction(transactionType, securityContext)).thenReturn((Object)secondTransaction);
        Mockito.when((Object)txBridge.getKernelTransactionBoundToThisThread(true)).thenReturn((Object)initialKTX, (Object[])new KernelTransaction[]{secondKTX});
        Mockito.when((Object)txBridge.get()).thenReturn((Object)secondStatement);
        Mockito.when((Object)secondStatement.queryRegistration()).thenReturn((Object)secondQueryRegistry);
        Neo4jTransactionalContext context = new Neo4jTransactionalContext(queryService, null, this.guard, txBridge, locker, initialTransaction, initialStatement, executingQuery);
        try {
            context.commitAndRestartTx();
            throw new AssertionError((Object)"Expected RuntimeException to be thrown");
        }
        catch (RuntimeException e) {
            Object[] mocks = new Object[]{txBridge, initialTransaction, initialQueryRegistry, initialKTX, secondQueryRegistry, secondKTX, secondTransaction};
            InOrder order = Mockito.inOrder((Object[])mocks);
            ((InternalTransaction)order.verify((Object)initialTransaction)).transactionType();
            ((InternalTransaction)order.verify((Object)initialTransaction)).securityContext();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).get();
            ((QueryRegistryOperations)order.verify((Object)secondQueryRegistry)).registerExecutingQuery(executingQuery);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).getKernelTransactionBoundToThisThread(true);
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(initialKTX);
            ((QueryRegistryOperations)order.verify((Object)initialQueryRegistry)).unregisterExecutingQuery(executingQuery);
            ((InternalTransaction)order.verify((Object)initialTransaction)).success();
            ((InternalTransaction)order.verify((Object)initialTransaction)).close();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).bindTransactionToCurrentThread(secondKTX);
            ((InternalTransaction)order.verify((Object)secondTransaction)).failure();
            ((InternalTransaction)order.verify((Object)secondTransaction)).close();
            ((ThreadToStatementContextBridge)order.verify((Object)txBridge)).unbindTransactionFromCurrentThread();
            Mockito.verifyNoMoreInteractions((Object[])mocks);
            return;
        }
    }

    private void setUpMocks() {
        this.queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        this.guard = (Guard)Mockito.mock(Guard.class);
        this.initialStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        QueryRegistryOperations queryRegistryOperations = (QueryRegistryOperations)Mockito.mock(QueryRegistryOperations.class);
        Mockito.when((Object)this.initialStatement.queryRegistration()).thenReturn((Object)queryRegistryOperations);
        Mockito.when((Object)this.queryService.getDependencyResolver()).thenReturn((Object)resolver);
        Mockito.when((Object)resolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)txBridge);
        Mockito.when((Object)resolver.resolveDependency(Guard.class)).thenReturn((Object)this.guard);
    }
}

