/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.StoreHeaderFormat;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CommonAbstractStoreBehaviourTest {
    private static final Config CONFIG = Config.empty().augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8M"}));
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final TestRule rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.pageCacheRule);
    private final Queue<Long> nextPageId = new ConcurrentLinkedQueue<Long>();
    private final Queue<Integer> nextPageOffset = new ConcurrentLinkedQueue<Integer>();
    private int cursorErrorOnRecord;
    private int intsPerRecord = 1;
    private MyStore store;
    private Config config = CONFIG;

    @After
    public void tearDown() {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.nextPageOffset.clear();
        this.nextPageId.clear();
    }

    private void assertThrowsUnderlyingStorageException(ThrowingAction<Exception> action) throws Exception {
        try {
            action.apply();
            Assert.fail((String)"expected an UnderlyingStorageException exception");
        }
        catch (UnderlyingStorageException underlyingStorageException) {
            // empty catch block
        }
    }

    private void assertThrowsInvalidRecordException(ThrowingAction<Exception> action) throws Exception {
        try {
            action.apply();
            Assert.fail((String)"expected an InvalidRecordException exception");
        }
        catch (InvalidRecordException invalidRecordException) {
            // empty catch block
        }
    }

    private void verifyExceptionOnOutOfBoundsAccess(ThrowingAction<Exception> access) throws Exception {
        this.prepareStoreForOutOfBoundsAccess();
        this.assertThrowsUnderlyingStorageException(access);
    }

    private void prepareStoreForOutOfBoundsAccess() {
        this.createStore();
        this.nextPageOffset.add(8190);
    }

    private void verifyExceptionOnCursorError(ThrowingAction<Exception> access) throws Exception {
        this.prepareStoreForCursorError();
        this.assertThrowsInvalidRecordException(access);
    }

    private void prepareStoreForCursorError() {
        this.createStore();
        this.cursorErrorOnRecord = 5;
    }

    private void createStore() {
        this.store = new MyStore(this.config, this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get(), this.config));
        this.store.initialise(true);
    }

    @Test
    public void writingOfHeaderRecordDuringInitialiseNewStoreFileMustThrowOnPageOverflow() throws Exception {
        MyStore store = new MyStore(this.config, this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get(), PageCacheTracer.NULL, 8, this.config));
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> store.initialise(true)));
    }

    @Test
    public void extractHeaderRecordDuringLoadStorageMustThrowOnPageOverflow() throws Exception {
        MyStore first = new MyStore(this.config, this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get(), this.config));
        first.initialise(true);
        first.close();
        MyStore second = new MyStore(this.config, this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get(), PageCacheTracer.NULL, 8, this.config));
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> second.initialise(false)));
    }

    @Test
    public void getRawRecordDataMustNotThrowOnPageOverflow() throws Exception {
        this.prepareStoreForOutOfBoundsAccess();
        this.store.getRawRecordData(5L);
    }

    @Test
    public void isInUseMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.isInUse(5L)));
    }

    @Test
    public void isInUseMustThrowOnCursorError() throws Exception {
        this.verifyExceptionOnCursorError((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.isInUse(5L)));
    }

    @Test
    public void getRecordMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> {
            IntRecord cfr_ignored_0 = (IntRecord)this.store.getRecord(5L, new IntRecord(5L), RecordLoad.NORMAL);
        }));
    }

    @Test
    public void getRecordMustNotThrowOnPageOverflowWithCheckLoadMode() throws Exception {
        this.prepareStoreForOutOfBoundsAccess();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.CHECK);
    }

    @Test
    public void getRecordMustNotThrowOnPageOverflowWithForceLoadMode() throws Exception {
        this.prepareStoreForOutOfBoundsAccess();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.FORCE);
    }

    @Test
    public void updateRecordMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.updateRecord(new IntRecord(5L))));
    }

    @Test
    public void getRecordMustThrowOnCursorError() throws Exception {
        this.verifyExceptionOnCursorError((ThrowingAction<Exception>)((ThrowingAction)() -> {
            IntRecord cfr_ignored_0 = (IntRecord)this.store.getRecord(5L, new IntRecord(5L), RecordLoad.NORMAL);
        }));
    }

    @Test
    public void getRecordMustNotThrowOnCursorErrorWithCheckLoadMode() throws Exception {
        this.prepareStoreForCursorError();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.CHECK);
    }

    @Test
    public void getRecordMustNotThrowOnCursorErrorWithForceLoadMode() throws Exception {
        this.prepareStoreForCursorError();
        this.store.getRecord(5L, new IntRecord(5L), RecordLoad.FORCE);
    }

    @Test
    public void recordCursorNextMustThrowOnPageOverflow() throws Exception {
        this.verifyExceptionOnOutOfBoundsAccess((ThrowingAction<Exception>)((ThrowingAction)() -> {
            try (RecordCursor cursor = this.store.newRecordCursor(new IntRecord(0L)).acquire(5L, RecordLoad.NORMAL);){
                cursor.next();
            }
        }));
    }

    @Test
    public void pageCursorErrorsMustNotLingerInRecordCursor() throws Exception {
        this.createStore();
        RecordCursor cursor = this.store.newRecordCursor(new IntRecord(1L)).acquire(1L, RecordLoad.FORCE);
        this.cursorErrorOnRecord = 1;
        Assert.assertTrue((boolean)cursor.next());
        Assert.assertTrue((boolean)cursor.next(2L, (AbstractBaseRecord)new IntRecord(2L), RecordLoad.NORMAL));
    }

    @Test
    public void rebuildIdGeneratorSlowMustThrowOnPageOverflow() throws Exception {
        this.config = this.config.with(MapUtil.stringMap((String[])new String[]{CommonAbstractStore.Configuration.rebuild_idgenerators_fast.name(), "false"}), new Class[0]);
        this.createStore();
        this.store.setStoreNotOk(new Exception());
        IntRecord record = new IntRecord(200L);
        record.value = -889275714;
        this.store.updateRecord(record);
        this.intsPerRecord = 8192;
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.makeStoreOk()));
    }

    @Test
    public void scanForHighIdMustThrowOnPageOverflow() throws Exception {
        this.createStore();
        this.store.setStoreNotOk(new Exception());
        IntRecord record = new IntRecord(200L);
        record.value = -889275714;
        this.store.updateRecord(record);
        this.intsPerRecord = 8192;
        this.assertThrowsUnderlyingStorageException((ThrowingAction<Exception>)((ThrowingAction)() -> this.store.makeStoreOk()));
    }

    private class MyStore
    extends CommonAbstractStore<IntRecord, LongLongHeader> {
        MyStore(Config config, PageCache pageCache) {
            this(config, pageCache, commonAbstractStoreBehaviourTest.new MyFormat());
        }

        MyStore(Config config, PageCache pageCache, MyFormat format) {
            super(new File("store"), config, IdType.NODE, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)CommonAbstractStoreBehaviourTest.this.fs.get()), pageCache, (LogProvider)NullLogProvider.getInstance(), "T", (RecordFormat)format, (StoreHeaderFormat)format, "XYZ", new OpenOption[0]);
        }

        public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, IntRecord record) throws FAILURE {
            throw new UnsupportedOperationException();
        }

        protected long pageIdForRecord(long id) {
            Long override = (Long)CommonAbstractStoreBehaviourTest.this.nextPageId.poll();
            return override != null ? override.longValue() : super.pageIdForRecord(id);
        }

        protected int offsetForId(long id) {
            Integer override = (Integer)CommonAbstractStoreBehaviourTest.this.nextPageOffset.poll();
            return override != null ? override.intValue() : super.offsetForId(id);
        }
    }

    private class MyFormat
    extends BaseRecordFormat<IntRecord>
    implements StoreHeaderFormat<LongLongHeader> {
        MyFormat() {
            super(x -> 4, 8, 32);
        }

        public IntRecord newRecord() {
            return new IntRecord(0L);
        }

        public boolean isInUse(PageCursor cursor) {
            int offset = cursor.getOffset();
            long pageId = cursor.getCurrentPageId();
            long recordId = ((long)offset + pageId * (long)cursor.getCurrentPageSize()) / 4L;
            boolean inUse = false;
            for (int i = 0; i < CommonAbstractStoreBehaviourTest.this.intsPerRecord; ++i) {
                inUse |= cursor.getInt() != 0;
            }
            this.maybeSetCursorError(cursor, recordId);
            return inUse;
        }

        public void read(IntRecord record, PageCursor cursor, RecordLoad mode, int recordSize) throws IOException {
            for (int i = 0; i < CommonAbstractStoreBehaviourTest.this.intsPerRecord; ++i) {
                record.value = cursor.getInt();
            }
            record.setInUse(true);
            this.maybeSetCursorError(cursor, record.getId());
        }

        private void maybeSetCursorError(PageCursor cursor, long id) {
            if ((long)CommonAbstractStoreBehaviourTest.this.cursorErrorOnRecord == id) {
                cursor.setCursorException("boom");
            }
        }

        public void write(IntRecord record, PageCursor cursor, int recordSize) throws IOException {
            for (int i = 0; i < CommonAbstractStoreBehaviourTest.this.intsPerRecord; ++i) {
                cursor.putInt(record.value);
            }
        }

        public int numberOfReservedRecords() {
            return 4;
        }

        public void writeHeader(PageCursor cursor) {
            cursor.putLong(182130864717438L);
            cursor.putLong(65125580675610L);
        }

        public LongLongHeader readHeader(PageCursor cursor) {
            LongLongHeader header = new LongLongHeader();
            cursor.getLong();
            cursor.getLong();
            return header;
        }
    }

    private static class LongLongHeader
    implements StoreHeader {
        private LongLongHeader() {
        }
    }

    private static class IntRecord
    extends AbstractBaseRecord {
        public int value;

        IntRecord(long id) {
            super(id);
            this.setInUse(true);
        }

        public String toString() {
            return "IntRecord[" + this.getId() + "](" + this.value + ")";
        }
    }
}

