/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;

public class CountsStoreMapGenerator {
    public static Map<CountsKey, long[]> simpleCountStoreMap(int num) {
        ConcurrentHashMap<CountsKey, long[]> map = new ConcurrentHashMap<CountsKey, long[]>();
        CountsStoreMapGenerator.addNodeKeys(num, map);
        CountsStoreMapGenerator.addRelationshipKeys(num, map);
        CountsStoreMapGenerator.addIndexSampleKeys(num, map);
        CountsStoreMapGenerator.addIndexStatisticsKeys(num, map);
        return map;
    }

    private static void addNodeKeys(int num, Map<CountsKey, long[]> map) {
        for (int i = 0; i < num; ++i) {
            map.put((CountsKey)CountsKeyFactory.nodeKey((int)i), new long[]{i});
        }
    }

    private static void addRelationshipKeys(int num, Map<CountsKey, long[]> map) {
        for (int i = 0; i < num; ++i) {
            map.put((CountsKey)CountsKeyFactory.relationshipKey((int)i, (int)i, (int)i), new long[]{i});
        }
    }

    private static void addIndexSampleKeys(int num, Map<CountsKey, long[]> map) {
        for (int i = 0; i < num; ++i) {
            map.put((CountsKey)CountsKeyFactory.indexSampleKey((int)i, (int)i), new long[]{i, i});
        }
    }

    private static void addIndexStatisticsKeys(int num, Map<CountsKey, long[]> map) {
        for (int i = 0; i < num; ++i) {
            map.put((CountsKey)CountsKeyFactory.indexStatisticsKey((int)i, (int)i), new long[]{i, i});
        }
    }
}

