/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Predicate;
import org.junit.Assert;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.Legacy21Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v22.Legacy22Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v23.Legacy23Store;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.string.UTF8;
import org.neo4j.test.Unzip;

public class MigrationTestUtils {
    private static final Predicate<StoreFile> ALL_EXCEPT_COUNTS_STORE = item -> item != StoreFile.COUNTS_STORE_LEFT && item != StoreFile.COUNTS_STORE_RIGHT;

    public static int[] makeLongArray() {
        int[] longArray = new int[100];
        for (int i = 0; i < 100; ++i) {
            longArray[i] = i;
        }
        return longArray;
    }

    public static String makeLongString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            builder.append("characters");
        }
        return builder.toString();
    }

    public static void changeVersionNumber(FileSystemAbstraction fileSystem, File storeFile, String versionString) throws IOException {
        byte[] versionBytes = UTF8.encode((String)versionString);
        try (StoreChannel fileChannel = fileSystem.open(storeFile, "rw");){
            fileChannel.position(fileSystem.getFileSize(storeFile) - (long)versionBytes.length);
            fileChannel.write(ByteBuffer.wrap(versionBytes));
        }
    }

    public static void truncateFile(FileSystemAbstraction fileSystem, File storeFile, String suffixToDetermineTruncationLength) throws IOException {
        byte[] versionBytes = UTF8.encode((String)suffixToDetermineTruncationLength);
        if (!fileSystem.fileExists(storeFile)) {
            return;
        }
        try (StoreChannel fileChannel = fileSystem.open(storeFile, "rw");){
            long fileSize = fileSystem.getFileSize(storeFile);
            fileChannel.truncate(Math.max(0L, fileSize - (long)versionBytes.length));
        }
    }

    public static void truncateAllFiles(FileSystemAbstraction fileSystem, File workingDirectory, String version) throws IOException {
        for (StoreFile storeFile : StoreFile.legacyStoreFilesForVersion((String)version)) {
            File file = new File(workingDirectory, storeFile.storeFileName());
            MigrationTestUtils.truncateFile(fileSystem, file, storeFile.forVersion(version));
        }
    }

    public static void truncateToFixedLength(FileSystemAbstraction fileSystem, File storeFile, int newLength) throws IOException {
        try (StoreChannel fileChannel = fileSystem.open(storeFile, "rw");){
            fileChannel.truncate((long)newLength);
        }
    }

    public static void prepareSampleLegacyDatabase(String version, EphemeralFileSystemAbstraction workingFs, File workingDirectory, File realDirForPreparingDatabase) throws IOException {
        File resourceDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(version, realDirForPreparingDatabase);
        workingFs.copyRecursivelyFromOtherFs(resourceDirectory, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), workingDirectory);
    }

    public static void prepareSampleLegacyDatabase(String version, FileSystemAbstraction workingFs, File workingDirectory, File prepareDirectory) throws IOException {
        if (!prepareDirectory.exists()) {
            throw new IllegalArgumentException("bad prepare directory");
        }
        File resourceDirectory = MigrationTestUtils.findFormatStoreDirectoryForVersion(version, prepareDirectory);
        workingFs.deleteRecursively(workingDirectory);
        workingFs.mkdirs(workingDirectory);
        workingFs.copyRecursively(resourceDirectory, workingDirectory);
    }

    public static File findFormatStoreDirectoryForVersion(String version, File targetDir) throws IOException {
        if (version.equals(StandardV2_3.STORE_VERSION)) {
            return MigrationTestUtils.find23FormatStoreDirectory(targetDir);
        }
        if (version.equals(StandardV2_2.STORE_VERSION)) {
            return MigrationTestUtils.find22FormatStoreDirectory(targetDir);
        }
        if (version.equals(StandardV2_1.STORE_VERSION)) {
            return MigrationTestUtils.find21FormatStoreDirectory(targetDir);
        }
        if (version.equals(StandardV2_0.STORE_VERSION)) {
            return MigrationTestUtils.find20FormatStoreDirectory(targetDir);
        }
        throw new IllegalArgumentException("Unknown version");
    }

    private static File find23FormatStoreDirectory(File targetDir) throws IOException {
        return Unzip.unzip(Legacy23Store.class, "upgradeTest23Db.zip", targetDir);
    }

    public static File find22FormatStoreDirectory(File targetDir) throws IOException {
        return Unzip.unzip(Legacy22Store.class, "upgradeTest22Db.zip", targetDir);
    }

    public static File find21FormatStoreDirectory(File targetDir) throws IOException {
        return Unzip.unzip(Legacy21Store.class, "upgradeTest21Db.zip", targetDir);
    }

    public static File find21FormatStoreDirectoryWithDuplicateProperties(File targetDir) throws IOException {
        return Unzip.unzip(Legacy21Store.class, "with-duplicate-properties.zip", targetDir);
    }

    public static File find20FormatStoreDirectory(File targetDir) throws IOException {
        return Unzip.unzip(Legacy20Store.class, "exampledb.zip", targetDir);
    }

    public static boolean allLegacyStoreFilesHaveVersion(FileSystemAbstraction fs, File dir, String version) {
        Iterable storeFilesWithGivenVersions = Iterables.filter(ALL_EXCEPT_COUNTS_STORE, (Iterable)StoreFile.legacyStoreFilesForVersion((String)version));
        LegacyStoreVersionCheck legacyStoreVersionCheck = new LegacyStoreVersionCheck(fs);
        boolean success = true;
        for (StoreFile storeFile : storeFilesWithGivenVersions) {
            File file = new File(dir, storeFile.storeFileName());
            success &= legacyStoreVersionCheck.hasVersion((File)file, (String)version, (boolean)storeFile.isOptional()).outcome.isSuccessful();
        }
        return success;
    }

    public static boolean allStoreFilesHaveNoTrailer(FileSystemAbstraction fs, File dir) {
        Iterable storeFilesWithGivenVersions = Iterables.filter(ALL_EXCEPT_COUNTS_STORE, (Iterable)StoreFile.legacyStoreFilesForVersion((String)StandardV3_0.STORE_VERSION));
        LegacyStoreVersionCheck legacyStoreVersionCheck = new LegacyStoreVersionCheck(fs);
        boolean success = true;
        for (StoreFile storeFile : storeFilesWithGivenVersions) {
            File file = new File(dir, storeFile.storeFileName());
            StoreVersionCheck.Result result = legacyStoreVersionCheck.hasVersion(file, StandardV3_0.STORE_VERSION, storeFile.isOptional());
            success &= result.outcome == StoreVersionCheck.Result.Outcome.unexpectedStoreVersion || result.outcome == StoreVersionCheck.Result.Outcome.storeVersionNotFound;
        }
        return success;
    }

    public static boolean containsAnyStoreFiles(FileSystemAbstraction fileSystem, File directory) {
        for (StoreFile file : StoreFile.values()) {
            if (!fileSystem.fileExists(new File(directory, file.storeFileName()))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkNeoStoreHasDefaultFormatVersion(StoreVersionCheck check, File workingDirectory) {
        File neostoreFile = new File(workingDirectory, "neostore");
        return check.hasVersion((File)neostoreFile, (String)RecordFormatSelector.defaultFormat().storeVersion()).outcome.isSuccessful();
    }

    public static void verifyFilesHaveSameContent(FileSystemAbstraction fileSystem, File original, File other) throws IOException {
        File[] files;
        int bufferBatchSize = 32768;
        block18: for (File originalFile : files = fileSystem.listFiles(original)) {
            File otherFile = new File(other, originalFile.getName());
            if (fileSystem.isDirectory(originalFile)) continue;
            try (StoreChannel originalChannel = fileSystem.open(originalFile, "r");
                 StoreChannel otherChannel = fileSystem.open(otherFile, "r");){
                ByteBuffer buffer = ByteBuffer.allocate(32768);
                while (true) {
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)originalChannel, (ByteBuffer)buffer, (int)32768)) {
                        continue block18;
                    }
                    byte[] originalBytes = new byte[buffer.limit()];
                    buffer.get(originalBytes);
                    if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)otherChannel, (ByteBuffer)buffer, (int)32768)) {
                        Assert.fail((String)"Files have different sizes");
                    }
                    byte[] otherBytes = new byte[buffer.limit()];
                    buffer.get(otherBytes);
                    Assert.assertArrayEquals((String)("Different content in " + originalFile), (byte[])originalBytes, (byte[])otherBytes);
                }
            }
        }
    }

    public static File isolatedMigrationDirectoryOf(File dbDirectory) {
        return new File(dbDirectory, "upgrade");
    }

    public static void removeCheckPointFromTxLog(FileSystemAbstraction fileSystem, File workingDirectory) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(workingDirectory, fileSystem);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LatestCheckPointFinder finder = new LatestCheckPointFinder(logFiles, fileSystem, (LogEntryReader)logEntryReader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find(logFiles.getHighestLogVersion());
        if (latestCheckPoint.commitsAfterCheckPoint) {
            return;
        }
        Assert.assertNotNull((Object)latestCheckPoint.checkPoint);
        LogPosition logPosition = latestCheckPoint.checkPoint.getLogPosition();
        File logFile = logFiles.getLogFileForVersion(logPosition.getLogVersion());
        fileSystem.truncate(logFile, logPosition.getByteOffset());
    }
}

