/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.legacylogs.LogEntrySortingCursor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.StorageCommand;

public class LogEntrySortingCursorTest {
    private static final Random random = new Random(42L);
    private final ReadableLogChannel channel = (ReadableLogChannel)Mockito.mock(ReadableLogChannel.class);
    private final LogEntryReader<ReadableLogChannel> reader = (LogEntryReader)Mockito.mock(LogEntryReader.class);

    @Test
    public void shouldDoNothingIfTheListIsOrdered() throws IOException {
        LogEntry start1 = this.start(1L);
        LogEntry command1 = this.command();
        LogEntry commit1 = this.commit(2L);
        LogEntry start2 = this.start(2L);
        LogEntry command2 = this.command();
        LogEntry commit2 = this.commit(3L);
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)this.id(start1, 1), (Object[])new LogEntry[]{this.id(command1, 1), this.id(commit1, 1), this.id(start2, 2), this.id(command2, 2), this.id(commit2, 2), null});
        LogEntrySortingCursor cursor = new LogEntrySortingCursor(this.reader, this.channel);
        List<LogEntry> expected = Arrays.asList(start1, command1, commit1, start2, command2, commit2);
        this.assertCursorContains(expected, cursor);
    }

    @Test
    public void shouldReorderBasedOnTheTxId() throws IOException {
        LogEntry start1 = this.start(3L);
        LogEntry command1 = this.command();
        LogEntry commit1 = this.commit(5L);
        LogEntry start2 = this.start(3L);
        LogEntry command2 = this.command();
        LogEntry commit2 = this.commit(4L);
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)this.id(start1, 1), (Object[])new LogEntry[]{this.id(command1, 1), this.id(start2, 2), this.id(command2, 2), this.id(commit2, 2), this.id(commit1, 1), null});
        LogEntrySortingCursor cursor = new LogEntrySortingCursor(this.reader, this.channel);
        List<LogEntry> expected = Arrays.asList(start2, command2, commit2, start1, command1, commit1);
        this.assertCursorContains(expected, cursor);
    }

    @Test
    public void shouldReorderWhenEntriesAreMixedUp() throws IOException {
        LogEntry start1 = this.start(3L);
        LogEntry command1 = this.command();
        LogEntry commit1 = this.commit(5L);
        LogEntry start2 = this.start(3L);
        LogEntry command2 = this.command();
        LogEntry commit2 = this.commit(4L);
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)this.id(start2, 2), (Object[])new LogEntry[]{this.id(start1, 1), this.id(command1, 1), this.id(command2, 2), this.id(commit2, 2), this.id(commit1, 1), null});
        LogEntrySortingCursor cursor = new LogEntrySortingCursor(this.reader, this.channel);
        List<LogEntry> expected = Arrays.asList(start2, command2, commit2, start1, command1, commit1);
        this.assertCursorContains(expected, cursor);
    }

    @Test
    public void shouldBeFineIfThereAreEntriesWithoutACommit() throws IOException {
        LogEntry start1 = this.start(3L);
        LogEntry command1 = this.command();
        LogEntry start2 = this.start(3L);
        LogEntry command2 = this.command();
        LogEntry commit2 = this.commit(4L);
        Mockito.when((Object)this.reader.readLogEntry((ReadableClosablePositionAwareChannel)this.channel)).thenReturn((Object)this.id(start2, 2), (Object[])new LogEntry[]{this.id(start1, 1), this.id(command1, 1), this.id(command2, 2), this.id(commit2, 2), null});
        LogEntrySortingCursor cursor = new LogEntrySortingCursor(this.reader, this.channel);
        List<LogEntry> expected = Arrays.asList(start2, command2, commit2);
        this.assertCursorContains(expected, cursor);
    }

    private void assertCursorContains(Iterable<LogEntry> entries, LogEntrySortingCursor cursor) throws IOException {
        for (LogEntry entry : entries) {
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((Object)entry, (Object)cursor.get());
        }
        Assert.assertFalse((boolean)cursor.next());
    }

    private LogEntry start(long lastTxId) {
        return new LogEntryStart(random.nextInt(), random.nextInt(), random.nextLong(), lastTxId, LogEntryStart.EMPTY_ADDITIONAL_ARRAY, LogPosition.UNSPECIFIED);
    }

    private LogEntry command() {
        NodeRecord before = new NodeRecord((long)random.nextInt());
        NodeRecord after = new NodeRecord((long)random.nextInt());
        return new LogEntryCommand((StorageCommand)new Command.NodeCommand(before, after));
    }

    private LogEntry commit(long txId) {
        return new OnePhaseCommit(txId, (long)random.nextInt());
    }

    private IdentifiableLogEntry id(LogEntry entry, int id) {
        return new IdentifiableLogEntry(entry, id);
    }
}

