/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LegacyStoreVersionCheckTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldReportMissingFileNotHavingSpecifiedVersion() {
        File missingFile = new File("/you/will/never/find/me");
        LegacyStoreVersionCheck storeVersionCheck = new LegacyStoreVersionCheck((FileSystemAbstraction)new EphemeralFileSystemAbstraction());
        Assert.assertFalse((boolean)storeVersionCheck.hasVersion((File)missingFile, (String)"version", (boolean)false).outcome.isSuccessful());
    }

    @Test
    public void shouldNotReportMissingOptionalFileNotHaveSpecifiedVersion() {
        File missingFile = new File("/you/will/never/find/me");
        LegacyStoreVersionCheck storeVersionCheck = new LegacyStoreVersionCheck((FileSystemAbstraction)new EphemeralFileSystemAbstraction());
        Assert.assertTrue((boolean)storeVersionCheck.hasVersion((File)missingFile, (String)"version", (boolean)true).outcome.isSuccessful());
    }

    @Test
    public void shouldReportShortFileDoesNotHaveSpecifiedVersion() throws IOException {
        File shortFile = this.fileContaining(this.fs.get(), "a");
        LegacyStoreVersionCheck storeVersionCheck = new LegacyStoreVersionCheck((FileSystemAbstraction)this.fs.get());
        Assert.assertFalse((boolean)storeVersionCheck.hasVersion((File)shortFile, (String)"version", (boolean)false).outcome.isSuccessful());
    }

    @Test
    public void shouldReportFileWithIncorrectVersion() throws IOException {
        File shortFile = this.fileContaining(this.fs.get(), "versionWhichIsIncorrect");
        LegacyStoreVersionCheck storeVersionCheck = new LegacyStoreVersionCheck((FileSystemAbstraction)this.fs.get());
        Assert.assertFalse((boolean)storeVersionCheck.hasVersion((File)shortFile, (String)"correctVersion 1", (boolean)false).outcome.isSuccessful());
    }

    @Test
    public void shouldReportFileWithCorrectVersion() throws IOException {
        File shortFile = this.fileContaining(this.fs.get(), "correctVersion 1");
        LegacyStoreVersionCheck storeVersionCheck = new LegacyStoreVersionCheck((FileSystemAbstraction)this.fs.get());
        Assert.assertTrue((boolean)storeVersionCheck.hasVersion((File)shortFile, (String)"correctVersion 1", (boolean)false).outcome.isSuccessful());
    }

    private File fileContaining(EphemeralFileSystemAbstraction fs, String content) throws IOException {
        File shortFile = new File("shortFile");
        try (OutputStream outputStream = fs.openAsOutputStream(shortFile, true);){
            outputStream.write(content.getBytes());
        }
        return shortFile;
    }
}

