/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_1;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class PhysicalLogCommandReaderV2_1Test {
    private long dynamicRecordId = 1L;

    @Test
    public void shouldReadPropertyCommandWithDeletedDynamicRecords() throws Exception {
        PhysicalLogCommandReaderV2_1 reader = new PhysicalLogCommandReaderV2_1();
        InMemoryClosableChannel data = new InMemoryClosableChannel();
        long id = 5L;
        int keyId = 6;
        byte[] data1 = new byte[]{1, 2, 3, 4, 5};
        byte[] data2 = new byte[]{6, 7, 8, 9, 10};
        long value = 1234L;
        PropertyRecord property = new PropertyRecord(id);
        property.setInUse(true);
        property.addPropertyBlock(this.propertyBlockWithSomeDynamicRecords(keyId, PropertyType.STRING, value, data1, data2));
        property.addDeletedRecord(this.dynamicRecord(false, null, PropertyType.STRING.intValue()));
        property.addDeletedRecord(this.dynamicRecord(false, null, PropertyType.STRING.intValue()));
        new Command.PropertyCommand(new PropertyRecord(id), property).serialize((WritableChannel)data);
        Command.PropertyCommand readCommand = (Command.PropertyCommand)reader.read((ReadableChannel)data);
        PropertyRecord readRecord = (PropertyRecord)readCommand.getAfter();
        Assert.assertEquals((long)id, (long)readRecord.getId());
        PropertyBlock readBlock = (PropertyBlock)Iterables.single((Iterable)readRecord);
        Assert.assertArrayEquals((byte[])data1, (byte[])((DynamicRecord)readBlock.getValueRecords().get(0)).getData());
        Assert.assertArrayEquals((byte[])data2, (byte[])((DynamicRecord)readBlock.getValueRecords().get(1)).getData());
        Assert.assertEquals((long)2L, (long)readRecord.getDeletedRecords().size());
    }

    private DynamicRecord dynamicRecord(boolean inUse, byte[] data, int type) {
        DynamicRecord record = new DynamicRecord(this.dynamicRecordId++);
        record.setInUse(inUse, type);
        if (data != null) {
            record.setData(data);
            record.setLength(data.length);
        }
        return record;
    }

    private PropertyBlock propertyBlockWithSomeDynamicRecords(int keyId, PropertyType type, long value, byte[] ... dynamicRecordData) {
        PropertyBlock block = new PropertyBlock();
        block.setSingleBlock(PropertyStore.singleBlockLongValue((int)keyId, (PropertyType)type, (long)value));
        for (byte[] bytes : dynamicRecordData) {
            block.addValueRecord(this.dynamicRecord(true, bytes, type.intValue()));
        }
        return block;
    }
}

